/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting.listener;

import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.codefx.libfx.nesting.Nesting;
import org.codefx.libfx.nesting.listener.NestedChangeListenerHandle;

public class NestedChangeListenerBuilder<T, O extends ObservableValue<T>> {
    private final Nesting<O> nesting;
    private ChangeListener<? super T> listener;

    private NestedChangeListenerBuilder(Nesting<O> nesting) {
        Objects.requireNonNull(nesting, "The argument 'nesting' must not be null.");
        this.nesting = nesting;
    }

    private NestedChangeListenerBuilder(NestedChangeListenerBuilder<T, O> other) {
        this.nesting = other.nesting;
    }

    public static <T, O extends ObservableValue<T>> NestedChangeListenerBuilder<T, O> forNesting(Nesting<O> nesting) {
        return new NestedChangeListenerBuilder<T, O>(nesting);
    }

    public Buildable withListener(ChangeListener<? super T> listener) {
        Objects.requireNonNull(listener, "The argument 'listener' must not be null.");
        this.listener = listener;
        return new Buildable(this);
    }

    public class Buildable
    extends NestedChangeListenerBuilder<T, O> {
        private boolean built;

        private Buildable(NestedChangeListenerBuilder<T, O> builder) {
            super(builder);
        }

        public NestedChangeListenerHandle<T> buildAttached() {
            NestedChangeListenerHandle listenerHandle = this.buildDetached();
            listenerHandle.attach();
            return listenerHandle;
        }

        public NestedChangeListenerHandle<T> buildDetached() {
            if (this.built) {
                throw new IllegalStateException("This builder can only build one 'NestedChangeListenerHandle'.");
            }
            this.built = true;
            return new NestedChangeListenerHandle(NestedChangeListenerBuilder.this.nesting, NestedChangeListenerBuilder.this.listener);
        }
    }
}

