/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import org.codefx.libfx.nesting.DeepNesting;
import org.codefx.libfx.nesting.Nesting;
import org.codefx.libfx.nesting.NestingStep;
import org.codefx.libfx.nesting.ShallowNesting;
import org.codefx.libfx.nesting.listener.NestedInvalidationListenerBuilder;
import org.codefx.libfx.nesting.listener.NestedInvalidationListenerHandle;

abstract class AbstractNestingBuilderOnObservable<T, O extends Observable> {
    private final O outerObservable;
    private final AbstractNestingBuilderOnObservable<?, ?> previousBuilder;
    private final NestingStep<?, ? extends O> nestingStep;

    protected AbstractNestingBuilderOnObservable(O outerObservable) {
        Objects.requireNonNull(outerObservable, "The argument 'outerObservable' must not be null.");
        this.outerObservable = outerObservable;
        this.previousBuilder = null;
        this.nestingStep = null;
    }

    protected <P> AbstractNestingBuilderOnObservable(AbstractNestingBuilderOnObservable<P, ?> previousBuilder, NestingStep<P, ? extends O> nestingStep) {
        Objects.requireNonNull(previousBuilder, "The argument 'previousBuilder' must not be null.");
        Objects.requireNonNull(nestingStep, "The argument 'nestingStep' must not be null.");
        this.outerObservable = null;
        this.previousBuilder = previousBuilder;
        this.nestingStep = nestingStep;
    }

    public Nesting<O> buildNesting() {
        if (this.isOuterBuilder()) {
            return new ShallowNesting<O>(this.outerObservable);
        }
        NestingConstructionKit kit = this.createNestingConstructionKit();
        return new DeepNesting(kit.getOuterObservable(), kit.getNestingSteps());
    }

    private boolean isOuterBuilder() {
        return this.outerObservable != null;
    }

    private NestingConstructionKit createNestingConstructionKit() {
        NestingConstructionKit kit = new NestingConstructionKit();
        this.fillNestingConstructionKit(kit);
        return kit;
    }

    private void fillNestingConstructionKit(NestingConstructionKit kit) {
        if (this.isOuterBuilder()) {
            kit.setOuterObservable((ObservableValue)this.outerObservable);
        } else {
            super.fillNestingConstructionKit(kit);
            kit.getNestingSteps().add(this.nestingStep);
        }
    }

    public NestedInvalidationListenerHandle addListener(InvalidationListener listener) {
        Nesting<O> nesting = this.buildNesting();
        return NestedInvalidationListenerBuilder.forNesting(nesting).withListener(listener).buildAttached();
    }

    protected static class NestingConstructionKit {
        private ObservableValue outerObservable;
        private final List<NestingStep> nestingSteps = new ArrayList<NestingStep>();

        public ObservableValue getOuterObservable() {
            return this.outerObservable;
        }

        public void setOuterObservable(ObservableValue outerObservable) {
            this.outerObservable = outerObservable;
        }

        public List<NestingStep> getNestingSteps() {
            return this.nestingSteps;
        }
    }
}

