/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.listener.handle;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ArrayChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableArray;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.codefx.libfx.listener.handle.ListenerHandle;
import org.codefx.libfx.listener.handle.ListenerHandleBuilder;

public class ListenerHandles {
    private ListenerHandles() {
    }

    public static <O, L> ListenerHandleBuilder<O, L> createFor(O observable, L listener) {
        return ListenerHandleBuilder.from(observable, listener);
    }

    public static ListenerHandle createAttached(Observable observable, InvalidationListener invalidationListener) {
        ListenerHandle handle = ListenerHandles.createDetached(observable, invalidationListener);
        handle.attach();
        return handle;
    }

    public static ListenerHandle createDetached(Observable observable, InvalidationListener invalidationListener) {
        return ListenerHandleBuilder.from(observable, invalidationListener).onAttach(Observable::addListener).onDetach(Observable::removeListener).buildDetached();
    }

    public static <T> ListenerHandle createAttached(ObservableValue<T> observableValue, ChangeListener<? super T> changeListener) {
        ListenerHandle handle = ListenerHandles.createDetached(observableValue, changeListener);
        handle.attach();
        return handle;
    }

    public static <T> ListenerHandle createDetached(ObservableValue<T> observableValue, ChangeListener<? super T> changeListener) {
        return ListenerHandleBuilder.from(observableValue, changeListener).onAttach(ObservableValue::addListener).onDetach(ObservableValue::removeListener).buildDetached();
    }

    public static <T extends ObservableArray<T>> ListenerHandle createAttached(ObservableArray<T> observableArray, ArrayChangeListener<T> changeListener) {
        ListenerHandle handle = ListenerHandles.createDetached(observableArray, changeListener);
        handle.attach();
        return handle;
    }

    public static <T extends ObservableArray<T>> ListenerHandle createDetached(ObservableArray<T> observableArray, ArrayChangeListener<T> changeListener) {
        return ListenerHandleBuilder.from(observableArray, changeListener).onAttach(ObservableArray::addListener).onDetach(ObservableArray::removeListener).buildDetached();
    }

    public static <E> ListenerHandle createAttached(ObservableList<E> observableList, ListChangeListener<? super E> changeListener) {
        ListenerHandle handle = ListenerHandles.createDetached(observableList, changeListener);
        handle.attach();
        return handle;
    }

    public static <E> ListenerHandle createDetached(ObservableList<E> observableList, ListChangeListener<? super E> changeListener) {
        return ListenerHandleBuilder.from(observableList, changeListener).onAttach(ObservableList::addListener).onDetach(ObservableList::removeListener).buildDetached();
    }

    public static <E> ListenerHandle createAttached(ObservableSet<E> observableSet, SetChangeListener<? super E> changeListener) {
        ListenerHandle handle = ListenerHandles.createDetached(observableSet, changeListener);
        handle.attach();
        return handle;
    }

    public static <E> ListenerHandle createDetached(ObservableSet<E> observableSet, SetChangeListener<? super E> changeListener) {
        return ListenerHandleBuilder.from(observableSet, changeListener).onAttach(ObservableSet::addListener).onDetach(ObservableSet::removeListener).buildDetached();
    }

    public static <K, V> ListenerHandle createAttached(ObservableMap<K, V> observableMap, MapChangeListener<? super K, ? super V> changeListener) {
        ListenerHandle handle = ListenerHandles.createDetached(observableMap, changeListener);
        handle.attach();
        return handle;
    }

    public static <K, V> ListenerHandle createDetached(ObservableMap<K, V> observableMap, MapChangeListener<? super K, ? super V> changeListener) {
        return ListenerHandleBuilder.from(observableMap, changeListener).onAttach(ObservableMap::addListener).onDetach(ObservableMap::removeListener).buildDetached();
    }
}

