/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.control.webview;

import java.util.Objects;
import java.util.Optional;
import javafx.scene.web.WebView;
import javax.swing.event.HyperlinkEvent;
import org.codefx.libfx.control.webview.DefaultWebViewHyperlinkListenerHandle;
import org.codefx.libfx.control.webview.WebViewHyperlinkListener;
import org.codefx.libfx.control.webview.WebViewHyperlinkListenerHandle;
import org.codefx.libfx.dom.DomEventConverter;
import org.codefx.libfx.dom.StaticDomEventConverter;
import org.w3c.dom.events.Event;

public final class WebViews {
    private WebViews() {
    }

    public static WebViewHyperlinkListenerHandle createHyperlinkListenerHandle(WebView webView, WebViewHyperlinkListener listener) {
        return WebViews.addHyperlinkListenerDetached(webView, listener, Optional.empty());
    }

    public static WebViewHyperlinkListenerHandle createHyperlinkListenerHandle(WebView webView, WebViewHyperlinkListener listener, HyperlinkEvent.EventType eventType) {
        Objects.requireNonNull(eventType, "The argument 'eventType' must not be null.");
        return WebViews.addHyperlinkListenerDetached(webView, listener, Optional.of(eventType));
    }

    public static WebViewHyperlinkListenerHandle addHyperlinkListener(WebView webView, WebViewHyperlinkListener listener) {
        WebViewHyperlinkListenerHandle listenerHandle = WebViews.addHyperlinkListenerDetached(webView, listener, Optional.empty());
        listenerHandle.attach();
        return listenerHandle;
    }

    public static WebViewHyperlinkListenerHandle addHyperlinkListener(WebView webView, WebViewHyperlinkListener listener, HyperlinkEvent.EventType eventType) {
        Objects.requireNonNull(eventType, "The argument 'eventType' must not be null.");
        WebViewHyperlinkListenerHandle listenerHandle = WebViews.addHyperlinkListenerDetached(webView, listener, Optional.of(eventType));
        listenerHandle.attach();
        return listenerHandle;
    }

    private static WebViewHyperlinkListenerHandle addHyperlinkListenerDetached(WebView webView, WebViewHyperlinkListener listener, Optional<HyperlinkEvent.EventType> eventTypeFilter) {
        Objects.requireNonNull(webView, "The argument 'webView' must not be null.");
        Objects.requireNonNull(listener, "The argument 'listener' must not be null.");
        Objects.requireNonNull(eventTypeFilter, "The argument 'eventTypeFilter' must not be null.");
        return new DefaultWebViewHyperlinkListenerHandle(webView, listener, eventTypeFilter, new DomEventConverter());
    }

    public static boolean canConvertToHyperlinkEvent(Event domEvent) {
        return StaticDomEventConverter.canConvertToHyperlinkEvent(domEvent);
    }

    public static HyperlinkEvent convertToHyperlinkEvent(Event domEvent, Object source) throws IllegalArgumentException {
        return StaticDomEventConverter.convertToHyperlinkEvent(domEvent, source);
    }

    public static String hyperlinkEventToString(HyperlinkEvent event) {
        Objects.requireNonNull(event, "The parameter 'event' must not be null.");
        return "HyperlinkEvent [type: " + event.getEventType() + "; " + "URL (description): " + event.getURL() + " (" + event.getDescription() + "); " + "source: " + event.getSource() + "; " + "source element: " + event.getSourceElement() + "]";
    }

    public static String domEventToString(Event event) {
        Objects.requireNonNull(event, "The parameter 'event' must not be null.");
        return "DOM-Event [target: " + event.getTarget() + "; " + "type: " + event.getType() + "; " + "time stamp: " + event.getTimeStamp() + "; " + "bubbles: " + event.getBubbles() + "; " + "cancelable: " + event.getCancelable() + "]";
    }
}

