/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.control.webview;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.concurrent.Worker;
import javafx.scene.web.WebView;
import javax.swing.event.HyperlinkEvent;
import org.codefx.libfx.concurrent.when.ExecuteAlwaysWhen;
import org.codefx.libfx.concurrent.when.ExecuteWhen;
import org.codefx.libfx.control.webview.WebViewHyperlinkListener;
import org.codefx.libfx.control.webview.WebViewHyperlinkListenerHandle;
import org.codefx.libfx.dom.DomEventConverter;
import org.codefx.libfx.dom.DomEventType;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class DefaultWebViewHyperlinkListenerHandle
implements WebViewHyperlinkListenerHandle {
    private final WebView webView;
    private final WebViewHyperlinkListener eventListener;
    private final Optional<HyperlinkEvent.EventType> eventTypeFilter;
    private final EventListener domEventListener;
    private final DomEventConverter eventConverter;
    private Optional<ExecuteAlwaysWhen<Worker.State>> attachWhenLoadSucceeds;
    private boolean attached;

    public DefaultWebViewHyperlinkListenerHandle(WebView webView, WebViewHyperlinkListener eventListener, Optional<HyperlinkEvent.EventType> eventTypeFilter, DomEventConverter eventConverter) {
        this.webView = webView;
        this.eventListener = eventListener;
        this.eventTypeFilter = eventTypeFilter;
        this.eventConverter = eventConverter;
        this.domEventListener = this::callHyperlinkListenerWithEvent;
    }

    @Override
    public void attach() {
        if (this.attached) {
            return;
        }
        this.attached = true;
        if (Platform.isFxApplicationThread()) {
            this.attachInApplicationThreadEachTimeLoadSucceeds();
        } else {
            Platform.runLater(() -> this.attachInApplicationThreadEachTimeLoadSucceeds());
        }
    }

    private void attachInApplicationThreadEachTimeLoadSucceeds() {
        ReadOnlyObjectProperty webWorkerState = this.webView.getEngine().getLoadWorker().stateProperty();
        ExecuteAlwaysWhen<Worker.State> attachWhenLoadSucceeds = ExecuteWhen.on(webWorkerState).when(state -> state == Worker.State.SUCCEEDED).thenAlways(state -> this.attachListenerInApplicationThread());
        this.attachWhenLoadSucceeds = Optional.of(attachWhenLoadSucceeds);
        attachWhenLoadSucceeds.executeWhen();
    }

    private void attachListenerInApplicationThread() {
        BiConsumer<EventTarget, String> addListener = (eventTarget, eventType) -> eventTarget.addEventListener((String)eventType, this.domEventListener, false);
        this.onEachLinkForEachManagedEventType(addListener);
    }

    @Override
    public void detach() {
        if (!this.attached) {
            return;
        }
        this.attached = false;
        if (Platform.isFxApplicationThread()) {
            this.detachInApplicationThread();
        } else {
            Platform.runLater(() -> this.detachInApplicationThread());
        }
    }

    private void detachInApplicationThread() {
        this.attachWhenLoadSucceeds.ifPresent(attachWhen -> attachWhen.cancel());
        this.attachWhenLoadSucceeds = Optional.empty();
        Worker.State webWorkerState = this.webView.getEngine().getLoadWorker().getState();
        if (webWorkerState == Worker.State.SUCCEEDED) {
            BiConsumer<EventTarget, String> removeListener = (eventTarget, eventType) -> eventTarget.removeEventListener((String)eventType, this.domEventListener, false);
            this.onEachLinkForEachManagedEventType(removeListener);
        }
    }

    private void onEachLinkForEachManagedEventType(BiConsumer<EventTarget, String> manageListener) {
        NodeList domNodeList = this.webView.getEngine().getDocument().getElementsByTagName("a");
        for (int i = 0; i < domNodeList.getLength(); ++i) {
            EventTarget domTarget = (EventTarget)((Object)domNodeList.item(i));
            this.onLinkForEachManagedEventType(domTarget, manageListener);
        }
    }

    private void onLinkForEachManagedEventType(EventTarget link, BiConsumer<EventTarget, String> manageListener) {
        Consumer<DomEventType> manageListenerForType = domEventType -> manageListener.accept(link, domEventType.getDomName());
        Stream.of(DomEventType.values()).filter(this::manageListenerForEventType).forEach(manageListenerForType);
    }

    private boolean manageListenerForEventType(DomEventType domEventType) {
        boolean domEventTypeHasRepresentation = domEventType.toHyperlinkEventType().isPresent();
        if (!domEventTypeHasRepresentation) {
            return false;
        }
        boolean filterOn = this.eventTypeFilter.isPresent();
        if (!filterOn) {
            return true;
        }
        return domEventType.toHyperlinkEventType().get() == this.eventTypeFilter.get();
    }

    private void callHyperlinkListenerWithEvent(Event domEvent) {
        boolean canNotConvertEvent;
        boolean bl = canNotConvertEvent = !this.eventConverter.canConvertToHyperlinkEvent(domEvent);
        if (canNotConvertEvent) {
            return;
        }
        HyperlinkEvent event = this.eventConverter.convertToHyperlinkEvent(domEvent, this.webView);
        boolean cancel = this.eventListener.hyperlinkUpdate(event);
        DefaultWebViewHyperlinkListenerHandle.cancel(domEvent, cancel);
    }

    private static void cancel(Event domEvent, boolean cancel) {
        if (domEvent.getCancelable() && cancel) {
            domEvent.preventDefault();
        }
    }
}

