/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.concurrent.when;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import org.codefx.libfx.concurrent.when.ExecuteAlwaysWhen;
import org.codefx.libfx.concurrent.when.ExecuteOnceWhen;

public class ExecuteWhen<T> {
    private final ObservableValue<T> observable;
    private Optional<Predicate<? super T>> condition;

    private ExecuteWhen(ObservableValue<T> observable) {
        Objects.requireNonNull(observable, "The argument 'observable' must not be null.");
        this.observable = observable;
        this.condition = Optional.empty();
    }

    public static <T> ExecuteWhen<T> on(ObservableValue<T> observable) {
        return new ExecuteWhen<T>(observable);
    }

    public ExecuteWhen<T> when(Predicate<? super T> condition) {
        Objects.requireNonNull(condition, "The argument 'condition' must not be null.");
        this.condition = Optional.of(condition);
        return this;
    }

    public ExecuteOnceWhen<T> thenOnce(Consumer<? super T> action) throws IllegalStateException {
        Objects.requireNonNull(action, "The argument 'action' must not be null.");
        this.ensureConditionWasSet();
        return new ExecuteOnceWhen<T>(this.observable, this.condition.get(), action);
    }

    public ExecuteAlwaysWhen<T> thenAlways(Consumer<? super T> action) throws IllegalStateException {
        Objects.requireNonNull(action, "The argument 'action' must not be null.");
        this.ensureConditionWasSet();
        return new ExecuteAlwaysWhen<T>(this.observable, this.condition.get(), action);
    }

    private void ensureConditionWasSet() throws IllegalStateException {
        boolean noCondition;
        boolean bl = noCondition = !this.condition.isPresent();
        if (noCondition) {
            throw new IllegalStateException("Set a condition with 'when(Predicate<? super T>)' before calling any 'then...' method.");
        }
    }
}

