/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.concurrent.when;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class ExecuteOnceWhen<T> {
    private final ObservableValue<T> observable;
    private final Predicate<? super T> condition;
    private final Consumer<? super T> action;
    private final AtomicBoolean willExecute;
    private final ChangeListener<T> listenerWhichExecutesAction;
    private final AtomicBoolean executeWhenWasAlreadyCalled;

    ExecuteOnceWhen(ObservableValue<T> observable, Predicate<? super T> condition, Consumer<? super T> action) {
        assert (observable != null) : "The argument 'observable' must not be null.";
        assert (condition != null) : "The argument 'condition' must not be null.";
        assert (action != null) : "The argument 'action' must not be null.";
        this.observable = observable;
        this.condition = condition;
        this.action = action;
        this.listenerWhichExecutesAction = (obs, oldValue, newValue) -> this.tryExecuteAction(newValue);
        this.executeWhenWasAlreadyCalled = new AtomicBoolean(false);
        this.willExecute = new AtomicBoolean(true);
    }

    public void executeWhen() throws IllegalStateException {
        boolean wasAlreadyCalled = this.executeWhenWasAlreadyCalled.getAndSet(true);
        if (wasAlreadyCalled) {
            throw new IllegalStateException("The method 'executeWhen' can only be called once.");
        }
        this.observable.addListener(this.listenerWhichExecutesAction);
        this.tryExecuteAction(this.observable.getValue());
    }

    private void tryExecuteAction(T currentValue) {
        boolean valueFailsGateway;
        boolean bl = valueFailsGateway = !this.condition.test(currentValue);
        if (valueFailsGateway) {
            return;
        }
        boolean actionCanBeExecuted = this.willExecute.getAndSet(false);
        if (actionCanBeExecuted) {
            this.action.accept(currentValue);
            this.observable.removeListener(this.listenerWhichExecutesAction);
        }
    }

    public void cancel() {
        this.willExecute.set(false);
        this.observable.removeListener(this.listenerWhichExecutesAction);
    }
}

