/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.concurrent.when;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class ExecuteAlwaysWhen<T> {
    private final ObservableValue<T> observable;
    private final Predicate<? super T> condition;
    private final Consumer<? super T> action;
    private final ChangeListener<? super T> listenerWhichExecutesAction;
    private final AtomicBoolean executeWhenWasAlreadyCalled;
    private final AtomicBoolean executeAlways;
    private final AtomicBoolean alreadyExecuted;

    ExecuteAlwaysWhen(ObservableValue<T> observable, Predicate<? super T> condition, Consumer<? super T> action) {
        assert (observable != null) : "The argument 'observable' must not be null.";
        assert (condition != null) : "The argument 'condition' must not be null.";
        assert (action != null) : "The argument 'action' must not be null.";
        this.observable = observable;
        this.condition = condition;
        this.action = action;
        this.listenerWhichExecutesAction = (obs, oldValue, newValue) -> this.tryExecuteAction(newValue);
        this.executeAlways = new AtomicBoolean(false);
        this.executeWhenWasAlreadyCalled = new AtomicBoolean(false);
        this.alreadyExecuted = new AtomicBoolean(false);
    }

    public void executeWhen() throws IllegalStateException {
        boolean wasAlreadyCalled = this.executeWhenWasAlreadyCalled.getAndSet(true);
        if (wasAlreadyCalled) {
            throw new IllegalStateException("The method 'executeWhen' must only be called once.");
        }
        this.observable.addListener(this.listenerWhichExecutesAction);
        this.tryExecuteAction(this.observable.getValue());
        this.executeAlways.set(true);
    }

    private void tryExecuteAction(T currentValue) {
        boolean canNotExecuteNow;
        boolean valueFailsGateway;
        boolean bl = valueFailsGateway = !this.condition.test(currentValue);
        if (valueFailsGateway) {
            return;
        }
        boolean bl2 = canNotExecuteNow = !this.canExecuteNow();
        if (canNotExecuteNow) {
            return;
        }
        this.action.accept(currentValue);
    }

    private boolean canExecuteNow() {
        if (this.executeAlways.get()) {
            this.alreadyExecuted.set(true);
            return true;
        }
        boolean alreadyExecutedOnce = this.alreadyExecuted.getAndSet(true);
        boolean canExecuteNow = !alreadyExecutedOnce;
        return canExecuteNow;
    }

    public void cancel() {
        this.observable.removeListener(this.listenerWhichExecutesAction);
    }
}

