/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.stream;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.codefx.libfx.collection.tree.navigate.TreeNavigator;
import org.codefx.libfx.collection.tree.stream.DfsTreeIterationStrategy;
import org.codefx.libfx.collection.tree.stream.TreeIterationStrategy;
import org.codefx.libfx.collection.tree.stream.TreeIterator;
import org.codefx.libfx.collection.tree.stream.TreePath;
import org.codefx.libfx.collection.tree.stream.TreePathFactory;

public class TreeStreams {
    public static <N> Stream<N> dfsFromRoot(TreeNavigator<N> navigator, N root) {
        TreePath initialPath = TreePathFactory.createWithSingleNode(root);
        DfsTreeIterationStrategy<N> strategy = new DfsTreeIterationStrategy<N>(navigator, initialPath);
        return TreeStreams.byStrategy(strategy);
    }

    public static <N> Stream<N> dfsFromWithin(TreeNavigator<N> navigator, N startNode) {
        TreePath initialPath = TreePathFactory.createFromRootToNode(navigator, startNode);
        DfsTreeIterationStrategy<N> strategy = new DfsTreeIterationStrategy<N>(navigator, initialPath);
        return TreeStreams.byStrategy(strategy);
    }

    public static <N> Stream<N> dfsFromWithin(TreeNavigator<N> navigator, N root, N startNode) {
        TreePath initialPath = TreePathFactory.createFromNodeToDescendant(navigator, root, startNode);
        DfsTreeIterationStrategy<N> strategy = new DfsTreeIterationStrategy<N>(navigator, initialPath);
        return TreeStreams.byStrategy(strategy);
    }

    public static <N> Stream<N> backwardDfs(TreeNavigator<N> navigator, N startNode) {
        TreePath initialPath = TreePathFactory.createFromRootToNode(navigator, startNode);
        DfsTreeIterationStrategy<N> strategy = new DfsTreeIterationStrategy<N>(navigator, initialPath);
        return TreeStreams.byStrategy(strategy);
    }

    public static <N> Stream<N> backwardDfsToRoot(TreeNavigator<N> navigator, N root, N startNode) {
        TreePath initialPath = TreePathFactory.createFromNodeToDescendant(navigator, root, startNode);
        DfsTreeIterationStrategy<N> strategy = new DfsTreeIterationStrategy<N>(navigator, initialPath);
        return TreeStreams.byStrategy(strategy);
    }

    public static <N> Stream<N> byStrategy(TreeIterationStrategy<N> strategy) {
        return TreeStreams.byStrategy(strategy, 272, false);
    }

    public static <N> Stream<N> byStrategy(TreeIterationStrategy<N> strategy, int characteristics, boolean parallel) {
        TreeIterator<N> iterator = new TreeIterator<N>(strategy);
        Spliterator<N> spliterator = Spliterators.spliteratorUnknownSize(iterator, characteristics);
        return StreamSupport.stream(spliterator, parallel);
    }
}

