/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.codefx.libfx.collection.tree.navigate.TreeNavigator;
import org.codefx.libfx.collection.tree.stream.SimpleTreeNode;
import org.codefx.libfx.collection.tree.stream.StackTreePath;
import org.codefx.libfx.collection.tree.stream.TreeNode;
import org.codefx.libfx.collection.tree.stream.TreePath;

class TreePathFactory {
    TreePathFactory() {
    }

    public static <E> TreePath<TreeNode<E>> createWithSingleNode(E node) {
        Objects.requireNonNull(node, "The argument 'node' must not be null.");
        return new StackTreePath<TreeNode<E>>(Collections.singletonList(SimpleTreeNode.root(node)));
    }

    public static <E> TreePath<TreeNode<E>> createFromElementList(TreeNavigator<E> navigator, List<E> pathAsList) {
        Objects.requireNonNull(navigator, "The argument 'navigator' must not be null.");
        Objects.requireNonNull(pathAsList, "The argument 'pathAsList' must not be null.");
        StackTreePath path = new StackTreePath();
        pathAsList.forEach(element -> {
            OptionalInt childIndex = navigator.getChildIndex(element);
            SimpleTreeNode<Object> node = SimpleTreeNode.node(element, childIndex);
            path.append(node);
        });
        return path;
    }

    public static <E> TreePath<TreeNode<E>> createFromNodeToDescendant(TreeNavigator<E> navigator, E node, E descendant) throws IllegalArgumentException {
        Objects.requireNonNull(navigator, "The argument 'navigator' must not be null.");
        Objects.requireNonNull(node, "The argument 'node' must not be null.");
        Objects.requireNonNull(descendant, "The argument 'descendant' must not be null.");
        if (node == descendant) {
            return TreePathFactory.createWithSingleNode(node);
        }
        List<TreeNode<E>> pathFromDescendantBackToNode = TreePathFactory.createPathFromDescendantBackToNode(navigator, node, descendant);
        return TreePathFactory.createPathByInverting(pathFromDescendantBackToNode);
    }

    private static <E> List<TreeNode<E>> createPathFromDescendantBackToNode(TreeNavigator<E> navigator, E node, E descendant) {
        List<TreeNode<E>> pathFromDescendantToNode = TreePathFactory.createPathWithSingleNode(navigator, descendant);
        Optional<E> parent = TreePathFactory.addAllAncestorsToPathUntilReachingNode(navigator, node, descendant, pathFromDescendantToNode);
        TreePathFactory.addNodeToPathOrThrowException(navigator, node, parent, descendant, pathFromDescendantToNode);
        return pathFromDescendantToNode;
    }

    private static <E> List<TreeNode<E>> createPathWithSingleNode(TreeNavigator<E> navigator, E descendant) {
        ArrayList<TreeNode<SimpleTreeNode<E>>> pathFromStartBackToNode = new ArrayList<TreeNode<SimpleTreeNode<E>>>();
        SimpleTreeNode<E> descendantNode = SimpleTreeNode.node(descendant, navigator.getChildIndex(descendant));
        pathFromStartBackToNode.add(descendantNode);
        return pathFromStartBackToNode;
    }

    private static <E> Optional<E> addAllAncestorsToPathUntilReachingNode(TreeNavigator<E> navigator, E node, E descendant, List<TreeNode<E>> pathFromStartBackToNode) {
        Optional<E> parent = navigator.getParent(descendant);
        while (parent.isPresent() && parent.get() != node) {
            SimpleTreeNode<E> parentNode = SimpleTreeNode.node(parent.get(), navigator.getChildIndex(parent.get()));
            pathFromStartBackToNode.add(parentNode);
            parent = navigator.getParent(parent.get());
        }
        return parent;
    }

    private static <E> void addNodeToPathOrThrowException(TreeNavigator<E> navigator, E node, Optional<E> parent, E descendant, List<TreeNode<E>> pathFromStartBackToNode) {
        if (!parent.isPresent() || parent.get() != node) {
            throw new IllegalArgumentException("The specified node '" + node + "' is no ancestor of the specified descendant '" + descendant + "'.");
        }
        SimpleTreeNode<E> startNode = SimpleTreeNode.node(node, navigator.getChildIndex(node));
        pathFromStartBackToNode.add(startNode);
    }

    private static <E> TreePath<TreeNode<E>> createPathByInverting(List<TreeNode<E>> pathFromDescendantBackToNode) {
        StackTreePath<TreeNode<E>> treePath = new StackTreePath<TreeNode<E>>();
        for (int i = pathFromDescendantBackToNode.size() - 1; i >= 0; --i) {
            treePath.append(pathFromDescendantBackToNode.get(i));
        }
        return treePath;
    }

    public static <E> TreePath<TreeNode<E>> createFromRootToNode(TreeNavigator<E> navigator, E node) {
        Objects.requireNonNull(navigator, "The argument 'navigator' must not be null.");
        Objects.requireNonNull(node, "The argument 'node' must not be null.");
        List<TreeNode<E>> pathFromDescendantBackToNode = TreePathFactory.createPathFromNodeBackToRoot(navigator, node);
        return TreePathFactory.createPathByInverting(pathFromDescendantBackToNode);
    }

    private static <E> List<TreeNode<E>> createPathFromNodeBackToRoot(TreeNavigator<E> navigator, E node) {
        List<TreeNode<E>> pathFromNodeToRoot = TreePathFactory.createPathWithSingleNode(navigator, node);
        TreePathFactory.addAllAncestorNodesToPath(navigator, node, pathFromNodeToRoot);
        return pathFromNodeToRoot;
    }

    private static <E> void addAllAncestorNodesToPath(TreeNavigator<E> navigator, E node, List<TreeNode<E>> pathFromStartBackToNode) {
        Optional<E> parent = navigator.getParent(node);
        while (parent.isPresent()) {
            SimpleTreeNode<E> parentNode = SimpleTreeNode.node(parent.get(), navigator.getChildIndex(parent.get()));
            pathFromStartBackToNode.add(parentNode);
            parent = navigator.getParent(parent.get());
        }
    }
}

