/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.stream;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.codefx.libfx.collection.tree.stream.TreeIterationStrategy;

class TreeIterator<E>
implements Iterator<E> {
    private final TreeIterationStrategy<E> iterationStrategy;
    private Optional<E> nextNode;
    private boolean returnedNextNode;

    public TreeIterator(TreeIterationStrategy<E> iterationStrategy) {
        Objects.requireNonNull(iterationStrategy, "The argument 'iterationStrategy' must not be null.");
        this.iterationStrategy = iterationStrategy;
        this.nextNode = Optional.empty();
        this.returnedNextNode = true;
    }

    @Override
    public final boolean hasNext() {
        this.goToNextNodeIfNecessary();
        return this.nextNode.isPresent();
    }

    @Override
    public final E next() {
        this.goToNextNodeIfNecessary();
        return this.returnNextNode();
    }

    private void goToNextNodeIfNecessary() {
        if (this.returnedNextNode) {
            this.nextNode = this.iterationStrategy.goToNextNode();
            this.returnedNextNode = false;
        }
    }

    private E returnNextNode() {
        if (this.nextNode.isPresent()) {
            this.returnedNextNode = true;
            return this.nextNode.get();
        }
        throw new NoSuchElementException("All nodes in the tree have been visited.");
    }
}

