/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.stream;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.codefx.libfx.collection.tree.stream.TreePath;

final class StackTreePath<N>
implements TreePath<N> {
    private final Deque<N> path = new ArrayDeque<N>();

    public StackTreePath() {
    }

    public StackTreePath(List<? extends N> initialPath) {
        this();
        Objects.requireNonNull(initialPath, "The argument 'initialPath' must not be null.");
        initialPath.forEach(this::append);
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    @Override
    public Optional<N> getEnd() {
        return Optional.ofNullable(this.path.peek());
    }

    @Override
    public void append(N node) {
        Objects.requireNonNull(node, "The argument 'node' must not be null.");
        this.path.push(node);
    }

    @Override
    public N removeEnd() throws NoSuchElementException {
        return this.path.pop();
    }
}

