/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.stream;

import java.util.Objects;
import java.util.OptionalInt;
import org.codefx.libfx.collection.tree.stream.TreeNode;

final class SimpleTreeNode<E>
implements TreeNode<E> {
    private final E element;
    private final OptionalInt childIndex;

    private SimpleTreeNode(E element, OptionalInt childIndex) {
        Objects.requireNonNull(element, "The argument 'element' must not be null.");
        Objects.requireNonNull(childIndex, "The argument 'childIndex' must not be null.");
        if (childIndex.isPresent() && childIndex.getAsInt() < 0) {
            throw new IllegalArgumentException("The 'childIndex' must be missing or non-negative.");
        }
        this.element = element;
        this.childIndex = childIndex;
    }

    public static <E> SimpleTreeNode<E> node(E element, OptionalInt childIndex) {
        return new SimpleTreeNode<E>(element, childIndex);
    }

    public static <E> SimpleTreeNode<E> root(E element) {
        return new SimpleTreeNode<E>(element, OptionalInt.empty());
    }

    public static <E> SimpleTreeNode<E> innerNode(E element, int childIndex) {
        return new SimpleTreeNode<E>(element, OptionalInt.of(childIndex));
    }

    @Override
    public E getElement() {
        return this.element;
    }

    @Override
    public OptionalInt getChildIndex() {
        return this.childIndex;
    }

    public String toString() {
        return "Node [" + this.element + ", " + this.childIndex + "]";
    }
}

