/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.stream;

import java.util.Objects;
import java.util.Optional;
import org.codefx.libfx.collection.tree.navigate.TreeNavigator;
import org.codefx.libfx.collection.tree.stream.SimpleTreeNode;
import org.codefx.libfx.collection.tree.stream.TreeIterationStrategy;
import org.codefx.libfx.collection.tree.stream.TreeNode;
import org.codefx.libfx.collection.tree.stream.TreePath;

final class DfsTreeIterationStrategy<E>
implements TreeIterationStrategy<E> {
    private final TreeNavigator<E> navigator;
    private final TreePath<TreeNode<E>> path;
    private boolean beforeFirst;

    public DfsTreeIterationStrategy(TreeNavigator<E> navigator, TreePath<TreeNode<E>> initialPath) {
        Objects.requireNonNull(navigator, "The argument 'navigator' must not be null.");
        Objects.requireNonNull(initialPath, "The argument 'initialPath' must not be null.");
        if (initialPath.isEmpty()) {
            throw new IllegalArgumentException("The 'initialPath' must not be empty.");
        }
        this.navigator = navigator;
        this.path = initialPath;
        this.beforeFirst = true;
    }

    @Override
    public Optional<E> goToNextNode() {
        if (this.path.isEmpty()) {
            return Optional.empty();
        }
        if (this.beforeFirst) {
            this.beforeFirst = false;
        } else {
            this.movePathEndToNextNode();
        }
        return this.path.getEnd().map(TreeNode::getElement);
    }

    private void movePathEndToNextNode() {
        Optional<TreeNode<E>> leftmostChild = this.getLeftmostChild();
        if (leftmostChild.isPresent()) {
            this.goToLeftmostChild(leftmostChild.get());
        } else {
            this.goToRightSiblingOrUncle();
        }
    }

    private Optional<TreeNode<E>> getLeftmostChild() {
        return this.path.getEnd().flatMap(node -> this.navigator.getChild(node.getElement(), 0)).map(child -> SimpleTreeNode.innerNode(child, 0));
    }

    private void goToLeftmostChild(TreeNode<E> leftmostChild) {
        this.path.append(leftmostChild);
    }

    private void goToRightSiblingOrUncle() {
        Optional<TreeNode> siblingOrUncle = Optional.empty();
        while (!siblingOrUncle.isPresent() && !this.path.isEmpty()) {
            TreeNode<E> currentNode = this.path.removeEnd();
            Optional<TreeNode<E>> parentNode = this.path.getEnd();
            if (!parentNode.isPresent()) continue;
            E parentElement = parentNode.get().getElement();
            int rightSiblingIndex = currentNode.getChildIndex().getAsInt() + 1;
            siblingOrUncle = this.navigator.getChild(parentElement, rightSiblingIndex).map(sibling -> SimpleTreeNode.innerNode(sibling, rightSiblingIndex));
        }
        siblingOrUncle.ifPresent(this.path::append);
    }
}

