/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.stream;

import java.util.Objects;
import java.util.Optional;
import org.codefx.libfx.collection.tree.navigate.TreeNavigator;
import org.codefx.libfx.collection.tree.stream.SimpleTreeNode;
import org.codefx.libfx.collection.tree.stream.TreeIterationStrategy;
import org.codefx.libfx.collection.tree.stream.TreeNode;
import org.codefx.libfx.collection.tree.stream.TreePath;

final class BackwardsDfsTreeIterationStrategy<E>
implements TreeIterationStrategy<E> {
    private final TreeNavigator<E> navigator;
    private final TreePath<TreeNode<E>> path;
    private boolean beforeFirst;

    public BackwardsDfsTreeIterationStrategy(TreeNavigator<E> navigator, TreePath<TreeNode<E>> initialPath) {
        Objects.requireNonNull(navigator, "The argument 'navigator' must not be null.");
        Objects.requireNonNull(initialPath, "The argument 'initialPath' must not be null.");
        if (initialPath.isEmpty()) {
            throw new IllegalArgumentException("The 'initialPath' must not be empty.");
        }
        this.navigator = navigator;
        this.path = initialPath;
        this.beforeFirst = true;
    }

    @Override
    public Optional<E> goToNextNode() {
        if (this.path.isEmpty()) {
            return Optional.empty();
        }
        if (this.beforeFirst) {
            this.beforeFirst = false;
        } else {
            this.movePathEndToNextNode();
        }
        return this.path.getEnd().map(TreeNode::getElement);
    }

    private void movePathEndToNextNode() {
        Optional<TreeNode<E>> leftSibling = this.goToParentAndGetLeftSibling();
        if (leftSibling.isPresent()) {
            this.goToRightmostAncestor(leftSibling.get());
        }
    }

    private Optional<TreeNode<E>> goToParentAndGetLeftSibling() {
        TreeNode<E> node = this.path.removeEnd();
        Optional<TreeNode<E>> parent = this.path.getEnd();
        if (parent.isPresent()) {
            int leftSiblingIndex = node.getChildIndex().getAsInt() - 1;
            return this.navigator.getChild(parent.get().getElement(), leftSiblingIndex).map(ls -> SimpleTreeNode.innerNode(ls, leftSiblingIndex));
        }
        return Optional.empty();
    }

    private void goToRightmostAncestor(TreeNode<E> leftSibling) {
        Optional<TreeNode<E>> rightmostChild = Optional.of(leftSibling);
        while (rightmostChild.isPresent()) {
            this.path.append(rightmostChild.get());
            int rightmostChildIndex = this.navigator.getChildrenCount(rightmostChild.get().getElement()) - 1;
            rightmostChild = this.navigator.getChild(rightmostChild.get().getElement(), rightmostChildIndex).map(child -> SimpleTreeNode.innerNode(child, rightmostChildIndex));
        }
    }
}

