/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.navigate;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.codefx.libfx.collection.tree.navigate.TreeNavigator;

public class SceneGraphNavigator
implements TreeNavigator<Node> {
    @Override
    public Optional<Node> getParent(Node child) {
        Objects.requireNonNull(child, "The argument 'child' must not be null.");
        return Optional.ofNullable(child.getParent());
    }

    @Override
    public OptionalInt getChildIndex(Node node) {
        Objects.requireNonNull(node, "The argument 'node' must not be null.");
        Parent parent = node.getParent();
        if (parent == null) {
            return OptionalInt.empty();
        }
        int childIndex = parent.getChildrenUnmodifiable().indexOf((Object)node);
        if (childIndex == -1) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(childIndex);
    }

    @Override
    public int getChildrenCount(Node parent) {
        Objects.requireNonNull(parent, "The argument 'parent' must not be null.");
        if (!(parent instanceof Parent)) {
            return 0;
        }
        return ((Parent)parent).getChildrenUnmodifiable().size();
    }

    @Override
    public Optional<Node> getChild(Node parent, int childIndex) {
        Objects.requireNonNull(parent, "The argument 'parent' must not be null.");
        if (childIndex < 0) {
            throw new IllegalArgumentException("The argument 'childIndex' must be non-negative.");
        }
        if (!(parent instanceof Parent)) {
            return Optional.empty();
        }
        return SceneGraphNavigator.getChild((Parent)parent, childIndex);
    }

    private static Optional<Node> getChild(Parent parent, int childIndex) {
        if (parent.getChildrenUnmodifiable().size() <= childIndex) {
            return Optional.empty();
        }
        try {
            return Optional.of(parent.getChildrenUnmodifiable().get(childIndex));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }
}

