/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.navigate;

import java.awt.Component;
import java.awt.Container;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.swing.JComponent;
import org.codefx.libfx.collection.tree.navigate.TreeNavigator;

public class JComponentHierarchyNavigator
implements TreeNavigator<JComponent> {
    @Override
    public Optional<JComponent> getParent(JComponent child) {
        Objects.requireNonNull(child, "The argument 'child' must not be null.");
        Container parent = child.getParent();
        if (!(parent instanceof JComponent)) {
            return Optional.empty();
        }
        return Optional.ofNullable((JComponent)parent);
    }

    @Override
    public OptionalInt getChildIndex(JComponent node) {
        Objects.requireNonNull(node, "The argument 'node' must not be null.");
        Container parent = node.getParent();
        if (parent == null) {
            return OptionalInt.empty();
        }
        if (!(parent instanceof JComponent)) {
            return OptionalInt.empty();
        }
        Component[] siblings = ((JComponent)parent).getComponents();
        return JComponentHierarchyNavigator.getIndex(node, siblings);
    }

    private static OptionalInt getIndex(Component node, Component[] siblings) {
        try {
            for (int i = 0; i < siblings.length; ++i) {
                if (siblings[i] != node) continue;
                return OptionalInt.of(i);
            }
            return OptionalInt.empty();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return OptionalInt.empty();
        }
    }

    @Override
    public int getChildrenCount(JComponent parent) {
        Objects.requireNonNull(parent, "The argument 'parent' must not be null.");
        return parent.getComponents().length;
    }

    @Override
    public Optional<JComponent> getChild(JComponent parent, int childIndex) {
        Objects.requireNonNull(parent, "The argument 'parent' must not be null.");
        if (childIndex < 0) {
            throw new IllegalArgumentException("The argument 'childIndex' must be non-negative.");
        }
        if (parent.getComponents().length <= childIndex) {
            return Optional.empty();
        }
        try {
            Component child = parent.getComponent(childIndex);
            if (!(child instanceof JComponent)) {
                return Optional.empty();
            }
            return Optional.of((JComponent)child);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }
}

