/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.tree.navigate;

import java.awt.Component;
import java.awt.Container;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.codefx.libfx.collection.tree.navigate.TreeNavigator;

public class ComponentHierarchyNavigator
implements TreeNavigator<Component> {
    @Override
    public Optional<Component> getParent(Component child) {
        Objects.requireNonNull(child, "The argument 'child' must not be null.");
        return Optional.ofNullable(child.getParent());
    }

    @Override
    public OptionalInt getChildIndex(Component node) {
        Objects.requireNonNull(node, "The argument 'node' must not be null.");
        Container parent = node.getParent();
        if (parent == null) {
            return OptionalInt.empty();
        }
        if (!(parent instanceof Container)) {
            return OptionalInt.empty();
        }
        Component[] siblings = parent.getComponents();
        return ComponentHierarchyNavigator.getIndex(node, siblings);
    }

    private static OptionalInt getIndex(Component node, Component[] siblings) {
        try {
            for (int i = 0; i < siblings.length; ++i) {
                if (siblings[i] != node) continue;
                return OptionalInt.of(i);
            }
            return OptionalInt.empty();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return OptionalInt.empty();
        }
    }

    @Override
    public int getChildrenCount(Component parent) {
        Objects.requireNonNull(parent, "The argument 'parent' must not be null.");
        if (!(parent instanceof Container)) {
            return 0;
        }
        return ((Container)parent).getComponents().length;
    }

    @Override
    public Optional<Component> getChild(Component parent, int childIndex) {
        Objects.requireNonNull(parent, "The argument 'parent' must not be null.");
        if (childIndex < 0) {
            throw new IllegalArgumentException("The argument 'childIndex' must be non-negative.");
        }
        if (!(parent instanceof Container)) {
            return Optional.empty();
        }
        return ComponentHierarchyNavigator.getChild((Container)parent, childIndex);
    }

    private static Optional<Component> getChild(Container parent, int childIndex) {
        if (parent.getComponents().length <= childIndex) {
            return Optional.empty();
        }
        try {
            return Optional.of(parent.getComponent(childIndex));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }
}

