/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Function;
import org.codefx.libfx.collection.transform.AbstractTransformingSpliterator;

public final class TransformingSpliterator<I, O>
extends AbstractTransformingSpliterator<I, O> {
    private final Spliterator<I> innerSpliterator;
    private final Function<? super I, ? extends O> transformToOuter;
    private final Function<? super O, ? extends I> transformToInner;

    public TransformingSpliterator(Spliterator<I> innerSpliterator, Function<? super I, ? extends O> transformToOuter, Function<? super O, ? extends I> transformToInner) {
        Objects.requireNonNull(innerSpliterator, "The argument 'innerSpliterator' must not be null.");
        Objects.requireNonNull(transformToInner, "The argument 'transformToInner' must not be null.");
        Objects.requireNonNull(transformToOuter, "The argument 'transformToOuter' must not be null.");
        this.innerSpliterator = innerSpliterator;
        this.transformToInner = transformToInner;
        this.transformToOuter = transformToOuter;
    }

    @Override
    protected Spliterator<I> getInnerSpliterator() {
        return this.innerSpliterator;
    }

    @Override
    protected O transformToOuter(I innerElement) {
        if (innerElement == null) {
            return null;
        }
        O outerElement = this.transformToOuter.apply(innerElement);
        Objects.requireNonNull(outerElement, "The transformation must not create null instances.");
        return outerElement;
    }

    @Override
    protected I transformToInner(O outerElement) {
        if (outerElement == null) {
            return null;
        }
        I innerElement = this.transformToInner.apply(outerElement);
        Objects.requireNonNull(innerElement, "The transformation must not create null instances.");
        return innerElement;
    }

    @Override
    protected Spliterator<O> wrapNewSpliterator(Spliterator<I> newSpliterator) {
        return new TransformingSpliterator<I, O>(newSpliterator, this.transformToOuter, this.transformToInner);
    }
}

