/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.codefx.libfx.collection.transform.TransformingMap;

public class TransformingMapBuilder<IK, OK, IV, OV> {
    private final Class<? super OK> outerKeyTypeToken;
    private final Class<? super IK> innerKeyTypeToken;
    private Function<? super IK, ? extends OK> transformToOuterKey;
    private Function<? super OK, ? extends IK> transformToInnerKey;
    private final Class<? super OV> outerValueTypeToken;
    private final Class<? super IV> innerValueTypeToken;
    private Function<? super IV, ? extends OV> transformToOuterValue;
    private Function<? super OV, ? extends IV> transformToInnerValue;

    private TransformingMapBuilder(Class<? super IK> innerKeyTypeToken, Class<? super OK> outerKeyTypeToken, Class<? super IV> innerValueTypeToken, Class<? super OV> outerValueTypeToken) {
        Objects.requireNonNull(innerKeyTypeToken, "The argument 'innerKeyTypeToken' must not be null.");
        Objects.requireNonNull(outerKeyTypeToken, "The argument 'outerKeyTypeToken' must not be null.");
        Objects.requireNonNull(innerValueTypeToken, "The argument 'innerValueTypeToken' must not be null.");
        Objects.requireNonNull(outerValueTypeToken, "The argument 'outerValueTypeToken' must not be null.");
        this.innerKeyTypeToken = innerKeyTypeToken;
        this.outerKeyTypeToken = outerKeyTypeToken;
        this.innerValueTypeToken = innerValueTypeToken;
        this.outerValueTypeToken = outerValueTypeToken;
    }

    public static <IK, OK, IV, OV> TransformingMapBuilder<IK, OK, IV, OV> forTypes(Class<? super IK> innerKeyTypeToken, Class<? super OK> outerKeyTypeToken, Class<? super IV> innerValueTypeToken, Class<? super OV> outerValueTypeToken) {
        return new TransformingMapBuilder<IK, OK, IV, OV>(innerKeyTypeToken, outerKeyTypeToken, innerValueTypeToken, outerValueTypeToken);
    }

    public static <IK, OK, IV, OV> TransformingMapBuilder<IK, OK, IV, OV> forTypesUnknown() {
        return TransformingMapBuilder.forTypes(Object.class, Object.class, Object.class, Object.class);
    }

    public TransformingMapBuilder<IK, OK, IV, OV> toOuterKey(Function<? super IK, ? extends OK> transformToOuterKey) {
        Objects.requireNonNull(transformToOuterKey, "The argument 'transformToOuterKey' must not be null.");
        this.transformToOuterKey = transformToOuterKey;
        return this;
    }

    public TransformingMapBuilder<IK, OK, IV, OV> toInnerKey(Function<? super OK, ? extends IK> transformToInnerKey) {
        Objects.requireNonNull(transformToInnerKey, "The argument 'transformToInnerKey' must not be null.");
        this.transformToInnerKey = transformToInnerKey;
        return this;
    }

    public TransformingMapBuilder<IK, OK, IV, OV> toOuterValue(Function<? super IV, ? extends OV> transformToOuterValue) {
        Objects.requireNonNull(transformToOuterValue, "The argument 'transformToOuterValue' must not be null.");
        this.transformToOuterValue = transformToOuterValue;
        return this;
    }

    public TransformingMapBuilder<IK, OK, IV, OV> toInnerValue(Function<? super OV, ? extends IV> transformToInnerValue) {
        Objects.requireNonNull(transformToInnerValue, "The argument 'transformToInnerValue' must not be null.");
        this.transformToInnerValue = transformToInnerValue;
        return this;
    }

    public TransformingMap<IK, OK, IV, OV> transformMap(Map<IK, IV> map) {
        return new TransformingMap<IK, OK, IV, OV>(map, this.innerKeyTypeToken, this.outerKeyTypeToken, this.transformToOuterKey, this.transformToInnerKey, this.innerValueTypeToken, this.outerValueTypeToken, this.transformToOuterValue, this.transformToInnerValue);
    }
}

