/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.codefx.libfx.collection.transform.AbstractTransformingMap;

public final class TransformingMap<IK, OK, IV, OV>
extends AbstractTransformingMap<IK, OK, IV, OV> {
    private final Map<IK, IV> innerMap;
    private final Class<? super OK> outerKeyTypeToken;
    private final Class<? super IK> innerKeyTypeToken;
    private final Function<? super IK, ? extends OK> transformToOuterKey;
    private final Function<? super OK, ? extends IK> transformToInnerKey;
    private final Class<? super OV> outerValueTypeToken;
    private final Class<? super IV> innerValueTypeToken;
    private final Function<? super IV, ? extends OV> transformToOuterValue;
    private final Function<? super OV, ? extends IV> transformToInnerValue;

    TransformingMap(Map<IK, IV> innerMap, Class<? super IK> innerKeyTypeToken, Class<? super OK> outerKeyTypeToken, Function<? super IK, ? extends OK> transformToOuterKey, Function<? super OK, ? extends IK> transformToInnerKey, Class<? super IV> innerValueTypeToken, Class<? super OV> outerValueTypeToken, Function<? super IV, ? extends OV> transformToOuterValue, Function<? super OV, ? extends IV> transformToInnerValue) {
        Objects.requireNonNull(innerMap, "The argument 'innerMap' must not be null.");
        Objects.requireNonNull(innerKeyTypeToken, "The argument 'innerKeyTypeToken' must not be null.");
        Objects.requireNonNull(outerKeyTypeToken, "The argument 'outerKeyTypeToken' must not be null.");
        Objects.requireNonNull(transformToOuterKey, "The argument 'transformToOuterKey' must not be null.");
        Objects.requireNonNull(transformToInnerKey, "The argument 'transformToInnerKey' must not be null.");
        Objects.requireNonNull(innerValueTypeToken, "The argument 'innerValueTypeToken' must not be null.");
        Objects.requireNonNull(outerValueTypeToken, "The argument 'outerValueTypeToken' must not be null.");
        Objects.requireNonNull(transformToOuterValue, "The argument 'transformToOuterValue' must not be null.");
        Objects.requireNonNull(transformToInnerValue, "The argument 'transformToInnerValue' must not be null.");
        this.innerMap = innerMap;
        this.outerKeyTypeToken = outerKeyTypeToken;
        this.innerKeyTypeToken = innerKeyTypeToken;
        this.transformToOuterKey = transformToOuterKey;
        this.transformToInnerKey = transformToInnerKey;
        this.outerValueTypeToken = outerValueTypeToken;
        this.innerValueTypeToken = innerValueTypeToken;
        this.transformToOuterValue = transformToOuterValue;
        this.transformToInnerValue = transformToInnerValue;
    }

    @Override
    protected Map<IK, IV> getInnerMap() {
        return this.innerMap;
    }

    @Override
    protected boolean isInnerKey(Object object) {
        return object == null || this.innerKeyTypeToken.isInstance(object);
    }

    @Override
    protected OK transformToOuterKey(IK innerKey) {
        if (innerKey == null) {
            return null;
        }
        OK outerKey = this.transformToOuterKey.apply(innerKey);
        Objects.requireNonNull(outerKey, "The transformation must not create null instances.");
        return outerKey;
    }

    @Override
    protected boolean isOuterKey(Object object) {
        return object == null || this.outerKeyTypeToken.isInstance(object);
    }

    @Override
    protected IK transformToInnerKey(OK outerKey) {
        if (outerKey == null) {
            return null;
        }
        IK innerKey = this.transformToInnerKey.apply(outerKey);
        Objects.requireNonNull(innerKey, "The transformation must not create null instances.");
        return innerKey;
    }

    @Override
    protected boolean isInnerValue(Object object) {
        return object == null || this.innerValueTypeToken.isInstance(object);
    }

    @Override
    protected OV transformToOuterValue(IV innerValue) {
        if (innerValue == null) {
            return null;
        }
        OV outerValue = this.transformToOuterValue.apply(innerValue);
        Objects.requireNonNull(outerValue, "The transformation must not create null instances.");
        return outerValue;
    }

    @Override
    protected boolean isOuterValue(Object object) {
        return object == null || this.outerValueTypeToken.isInstance(object);
    }

    @Override
    protected IV transformToInnerValue(OV outerValue) {
        if (outerValue == null) {
            return null;
        }
        IV innerValue = this.transformToInnerValue.apply(outerValue);
        Objects.requireNonNull(innerValue, "The transformation must not create null instances.");
        return innerValue;
    }
}

