/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;
import org.codefx.libfx.collection.transform.AbstractTransformingListIterator;

public final class TransformingListIterator<I, O>
extends AbstractTransformingListIterator<I, O> {
    private final ListIterator<I> innerListIterator;
    private final Function<? super I, ? extends O> transformToOuter;
    private final Function<? super O, ? extends I> transformToInner;

    public TransformingListIterator(ListIterator<I> innerListIterator, Function<? super I, ? extends O> transformToOuter, Function<? super O, ? extends I> transformToInner) {
        Objects.requireNonNull(innerListIterator, "The argument 'innerListIterator' must not be null.");
        Objects.requireNonNull(transformToOuter, "The argument 'transformToOuter' must not be null.");
        Objects.requireNonNull(transformToInner, "The argument 'transformToInner' must not be null.");
        this.innerListIterator = innerListIterator;
        this.transformToOuter = transformToOuter;
        this.transformToInner = transformToInner;
    }

    @Override
    protected ListIterator<I> getInnerIterator() {
        return this.innerListIterator;
    }

    @Override
    protected O transformToOuter(I innerElement) {
        if (innerElement == null) {
            return null;
        }
        O outerElement = this.transformToOuter.apply(innerElement);
        Objects.requireNonNull(outerElement, "The transformation must not create null instances.");
        return outerElement;
    }

    @Override
    protected I transformToInner(O outerElement) {
        if (outerElement == null) {
            return null;
        }
        I innerElement = this.transformToInner.apply(outerElement);
        Objects.requireNonNull(innerElement, "The transformation must not create null instances.");
        return innerElement;
    }
}

