/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.codefx.libfx.collection.transform.AbstractTransformingList;

public final class TransformingList<I, O>
extends AbstractTransformingList<I, O> {
    private final List<I> innerList;
    private final Class<? super I> innerTypeToken;
    private final Class<? super O> outerTypeToken;
    private final Function<? super I, ? extends O> transformToOuter;
    private final Function<? super O, ? extends I> transformToInner;

    public TransformingList(List<I> innerList, Class<? super I> innerTypeToken, Class<? super O> outerTypeToken, Function<? super I, ? extends O> transformToOuter, Function<? super O, ? extends I> transformToInner) {
        Objects.requireNonNull(innerList, "The argument 'innerList' must not be null.");
        Objects.requireNonNull(innerTypeToken, "The argument 'innerTypeToken' must not be null.");
        Objects.requireNonNull(outerTypeToken, "The argument 'outerTypeToken' must not be null.");
        Objects.requireNonNull(transformToOuter, "The argument 'transformToOuter' must not be null.");
        Objects.requireNonNull(transformToInner, "The argument 'transformToInner' must not be null.");
        this.innerList = innerList;
        this.innerTypeToken = innerTypeToken;
        this.outerTypeToken = outerTypeToken;
        this.transformToOuter = transformToOuter;
        this.transformToInner = transformToInner;
    }

    @Override
    protected List<I> getInnerList() {
        return this.innerList;
    }

    @Override
    protected boolean isInnerElement(Object object) {
        return object == null || this.innerTypeToken.isInstance(object);
    }

    @Override
    protected O transformToOuter(I innerElement) {
        if (innerElement == null) {
            return null;
        }
        O outerElement = this.transformToOuter.apply(innerElement);
        Objects.requireNonNull(outerElement, "The transformation must not create null instances.");
        return outerElement;
    }

    @Override
    protected boolean isOuterElement(Object object) {
        return object == null || this.outerTypeToken.isInstance(object);
    }

    @Override
    protected I transformToInner(O outerElement) {
        if (outerElement == null) {
            return null;
        }
        I innerElement = this.transformToInner.apply(outerElement);
        Objects.requireNonNull(innerElement, "The transformation must not create null instances.");
        return innerElement;
    }
}

