/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.codefx.libfx.collection.transform.AbstractTransformingIterator;

public final class TransformingIterator<I, O>
extends AbstractTransformingIterator<I, O> {
    private final Iterator<? extends I> innerIterator;
    private final Function<? super I, ? extends O> transformToOuter;

    public TransformingIterator(Iterator<? extends I> innerIterator, Function<? super I, ? extends O> transformToOuter) {
        Objects.requireNonNull(innerIterator, "The argument 'innerIterator' must not be null.");
        Objects.requireNonNull(transformToOuter, "The argument 'transformToOuter' must not be null.");
        this.innerIterator = innerIterator;
        this.transformToOuter = transformToOuter;
    }

    @Override
    protected Iterator<? extends I> getInnerIterator() {
        return this.innerIterator;
    }

    @Override
    protected O transformToOuter(I innerElement) {
        if (innerElement == null) {
            return null;
        }
        O outerElement = this.transformToOuter.apply(innerElement);
        Objects.requireNonNull(outerElement, "The transformation must not create null instances.");
        return outerElement;
    }
}

