/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.codefx.libfx.collection.transform.TransformingCollection;
import org.codefx.libfx.collection.transform.TransformingList;
import org.codefx.libfx.collection.transform.TransformingSet;

public class TransformingCollectionBuilder<I, O> {
    private final Class<? super O> outerTypeToken;
    private final Class<? super I> innerTypeToken;
    private Function<? super I, ? extends O> transformToOuter;
    private Function<? super O, ? extends I> transformToInner;

    private TransformingCollectionBuilder(Class<? super I> innerTypeToken, Class<? super O> outerTypeToken) {
        Objects.requireNonNull(innerTypeToken, "The argument 'innerTypeToken' must not be null.");
        Objects.requireNonNull(outerTypeToken, "The argument 'outerTypeToken' must not be null.");
        this.outerTypeToken = outerTypeToken;
        this.innerTypeToken = innerTypeToken;
    }

    public static <I, O> TransformingCollectionBuilder<I, O> forInnerAndOuterType(Class<? super I> innerTypeToken, Class<? super O> outerTypeToken) {
        return new TransformingCollectionBuilder<I, O>(innerTypeToken, outerTypeToken);
    }

    public static <I, O> TransformingCollectionBuilder<I, O> forInnerAndOuterTypeUnknown() {
        return TransformingCollectionBuilder.forInnerAndOuterType(Object.class, Object.class);
    }

    public TransformingCollectionBuilder<I, O> toOuter(Function<? super I, ? extends O> transformToOuter) {
        Objects.requireNonNull(transformToOuter, "The argument 'transformToOuter' must not be null.");
        this.transformToOuter = transformToOuter;
        return this;
    }

    public TransformingCollectionBuilder<I, O> toInner(Function<? super O, ? extends I> transformToInner) {
        Objects.requireNonNull(transformToInner, "The argument 'transformToInner' must not be null.");
        this.transformToInner = transformToInner;
        return this;
    }

    public TransformingCollection<I, O> transformCollection(Collection<I> collection) {
        return new TransformingCollection<I, O>(collection, this.innerTypeToken, this.outerTypeToken, this.transformToOuter, this.transformToInner);
    }

    public TransformingSet<I, O> transformSet(Set<I> set) {
        return new TransformingSet<I, O>(set, this.innerTypeToken, this.outerTypeToken, this.transformToOuter, this.transformToInner);
    }

    public TransformingList<I, O> transformList(List<I> list) {
        return new TransformingList<I, O>(list, this.innerTypeToken, this.outerTypeToken, this.transformToOuter, this.transformToInner);
    }
}

