/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.codefx.libfx.collection.transform.AbstractTransformingSet;

public final class OptionalTransformingSet<E>
extends AbstractTransformingSet<Optional<E>, E> {
    private final Set<Optional<E>> innerSet;
    private final Class<? super E> outerTypeToken;
    private final E outerDefaultElement;

    public OptionalTransformingSet(Set<Optional<E>> innerSet, Class<? super E> outerTypeToken, E outerDefaultElement) {
        Objects.requireNonNull(innerSet, "The argument 'innerSet' must not be null.");
        Objects.requireNonNull(outerTypeToken, "The argument 'outerTypeToken' must not be null.");
        this.innerSet = innerSet;
        this.outerTypeToken = outerTypeToken;
        this.outerDefaultElement = outerDefaultElement;
    }

    public OptionalTransformingSet(Set<Optional<E>> innerSet) {
        this(innerSet, Object.class, null);
    }

    public OptionalTransformingSet(Set<Optional<E>> innerSet, Class<? super E> outerTypeToken) {
        this(innerSet, outerTypeToken, null);
    }

    public OptionalTransformingSet(Set<Optional<E>> innerSet, E outerDefaultElement) {
        this(innerSet, OptionalTransformingSet.getClassOfDefaultElement(outerDefaultElement), outerDefaultElement);
    }

    private static <T> Class<T> getClassOfDefaultElement(T outerDefaultElement) {
        Objects.requireNonNull(outerDefaultElement, "The argument 'outerDefaultElement' must not be null.");
        return outerDefaultElement.getClass();
    }

    @Override
    protected Set<Optional<E>> getInnerSet() {
        return this.innerSet;
    }

    @Override
    protected boolean isInnerElement(Object object) {
        if (this.outerDefaultElement != null) {
            Objects.requireNonNull(object, "When the outer default element is not null, this collection rejects nulls.");
        }
        return Optional.class.isInstance(object);
    }

    @Override
    protected E transformToOuter(Optional<E> innerElement) {
        Objects.requireNonNull(innerElement, "No element of the inner collection can be null.");
        return innerElement.orElse(this.outerDefaultElement);
    }

    @Override
    protected boolean isOuterElement(Object object) {
        return this.outerTypeToken.isInstance(object) || Objects.equals(object, this.outerDefaultElement);
    }

    @Override
    protected Optional<E> transformToInner(E outerElement) {
        if (this.outerDefaultElement != null) {
            Objects.requireNonNull(outerElement, "The argument 'outerElement' must not be null.");
        }
        return Objects.equals(outerElement, this.outerDefaultElement) ? Optional.empty() : Optional.of(outerElement);
    }
}

