/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.codefx.libfx.collection.transform.AbstractTransformingList;

public final class OptionalTransformingList<E>
extends AbstractTransformingList<Optional<E>, E> {
    private final List<Optional<E>> innerList;
    private final Class<? super E> outerTypeToken;
    private final E outerDefaultElement;

    public OptionalTransformingList(List<Optional<E>> innerList, Class<? super E> outerTypeToken, E outerDefaultElement) {
        Objects.requireNonNull(innerList, "The argument 'innerList' must not be null.");
        Objects.requireNonNull(outerTypeToken, "The argument 'outerTypeToken' must not be null.");
        this.innerList = innerList;
        this.outerTypeToken = outerTypeToken;
        this.outerDefaultElement = outerDefaultElement;
    }

    public OptionalTransformingList(List<Optional<E>> innerList) {
        this(innerList, Object.class, null);
    }

    public OptionalTransformingList(List<Optional<E>> innerList, Class<? super E> outerTypeToken) {
        this(innerList, outerTypeToken, null);
    }

    public OptionalTransformingList(List<Optional<E>> innerList, E outerDefaultElement) {
        this(innerList, OptionalTransformingList.getClassOfDefaultElement(outerDefaultElement), outerDefaultElement);
    }

    private static <T> Class<T> getClassOfDefaultElement(T outerDefaultElement) {
        Objects.requireNonNull(outerDefaultElement, "The argument 'outerDefaultElement' must not be null.");
        return outerDefaultElement.getClass();
    }

    @Override
    protected List<Optional<E>> getInnerList() {
        return this.innerList;
    }

    @Override
    protected boolean isInnerElement(Object object) {
        if (this.outerDefaultElement != null) {
            Objects.requireNonNull(object, "When the outer default element is not null, this collection rejects nulls.");
        }
        return Optional.class.isInstance(object);
    }

    @Override
    protected E transformToOuter(Optional<E> innerElement) {
        Objects.requireNonNull(innerElement, "No element of the inner collection can be null.");
        return innerElement.orElse(this.outerDefaultElement);
    }

    @Override
    protected boolean isOuterElement(Object object) {
        return this.outerTypeToken.isInstance(object) || Objects.equals(object, this.outerDefaultElement);
    }

    @Override
    protected Optional<E> transformToInner(E outerElement) {
        if (this.outerDefaultElement != null) {
            Objects.requireNonNull(outerElement, "The argument 'outerElement' must not be null.");
        }
        return Objects.equals(outerElement, this.outerDefaultElement) ? Optional.empty() : Optional.of(outerElement);
    }
}

