/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.codefx.libfx.collection.transform.AbstractTransformingCollection;

public final class OptionalTransformingCollection<E>
extends AbstractTransformingCollection<Optional<E>, E> {
    private final Collection<Optional<E>> innerCollection;
    private final Class<? super E> outerTypeToken;
    private final E outerDefaultElement;

    public OptionalTransformingCollection(Collection<Optional<E>> innerCollection, Class<? super E> outerTypeToken, E outerDefaultElement) {
        Objects.requireNonNull(innerCollection, "The argument 'innerCollection' must not be null.");
        Objects.requireNonNull(outerTypeToken, "The argument 'outerTypeToken' must not be null.");
        this.innerCollection = innerCollection;
        this.outerTypeToken = outerTypeToken;
        this.outerDefaultElement = outerDefaultElement;
    }

    public OptionalTransformingCollection(Collection<Optional<E>> innerCollection) {
        this(innerCollection, Object.class, null);
    }

    public OptionalTransformingCollection(Collection<Optional<E>> innerCollection, Class<? super E> outerTypeToken) {
        this(innerCollection, outerTypeToken, null);
    }

    public OptionalTransformingCollection(Collection<Optional<E>> innerCollection, E outerDefaultElement) {
        this(innerCollection, OptionalTransformingCollection.getClassOfDefaultElement(outerDefaultElement), outerDefaultElement);
    }

    private static <T> Class<T> getClassOfDefaultElement(T outerDefaultElement) {
        Objects.requireNonNull(outerDefaultElement, "The argument 'outerDefaultElement' must not be null.");
        return outerDefaultElement.getClass();
    }

    @Override
    protected Collection<Optional<E>> getInnerCollection() {
        return this.innerCollection;
    }

    @Override
    protected boolean isInnerElement(Object object) {
        if (this.outerDefaultElement != null) {
            Objects.requireNonNull(object, "When the outer default element is not null, this collection rejects nulls.");
        }
        return Optional.class.isInstance(object);
    }

    @Override
    protected E transformToOuter(Optional<E> innerElement) {
        Objects.requireNonNull(innerElement, "No element of the inner collection can be null.");
        return innerElement.orElse(this.outerDefaultElement);
    }

    @Override
    protected boolean isOuterElement(Object object) {
        return this.outerTypeToken.isInstance(object) || Objects.equals(object, this.outerDefaultElement);
    }

    @Override
    protected Optional<E> transformToInner(E outerElement) {
        if (this.outerDefaultElement != null) {
            Objects.requireNonNull(outerElement, "The argument 'outerElement' must not be null.");
        }
        return Objects.equals(outerElement, this.outerDefaultElement) ? Optional.empty() : Optional.of(outerElement);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        Collection other = (Collection)object;
        if (this.isThisCollection(other)) {
            return true;
        }
        return other.containsAll(this) && this.containsAll(other);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object outerElement : this) {
            hashCode = 31 * hashCode + (outerElement == null ? 0 : outerElement.hashCode());
        }
        return hashCode;
    }
}

