/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import org.codefx.libfx.collection.transform.AbstractTransformingSet;
import org.codefx.libfx.collection.transform.EqHash;

public class EqualityTransformingSet<E>
extends AbstractTransformingSet<EqHash<E>, E> {
    private final Set<EqHash<E>> innerSet;
    private final Class<? super E> outerTypeToken;
    private final BiPredicate<? super E, ? super E> equals;
    private final ToIntFunction<? super E> hash;

    EqualityTransformingSet(Set<?> innerSet, Class<? super E> outerTypeToken, BiPredicate<? super E, ? super E> equals, ToIntFunction<? super E> hash) {
        this.innerSet = EqualityTransformingSet.castInnerSet(innerSet);
        this.outerTypeToken = outerTypeToken;
        this.equals = equals;
        this.hash = hash;
    }

    private static <E> Set<EqHash<E>> castInnerSet(Set<?> untypedInnerSet) {
        Set<EqHash<E>> innerMap = untypedInnerSet;
        return innerMap;
    }

    @Override
    protected Set<EqHash<E>> getInnerSet() {
        return this.innerSet;
    }

    @Override
    protected boolean isInnerElement(Object object) {
        return object instanceof EqHash;
    }

    @Override
    protected E transformToOuter(EqHash<E> innerElement) throws ClassCastException {
        return innerElement.getElement();
    }

    @Override
    protected boolean isOuterElement(Object object) {
        return object == null || this.outerTypeToken.isInstance(object);
    }

    @Override
    protected EqHash<E> transformToInner(E outerElement) throws ClassCastException {
        return EqHash.create(outerElement, this.equals, this.hash);
    }
}

