/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import org.codefx.libfx.collection.transform.AbstractTransformingMap;
import org.codefx.libfx.collection.transform.EqHash;

public final class EqualityTransformingMap<K, V>
extends AbstractTransformingMap<EqHash<K>, K, V, V> {
    private final Map<EqHash<K>, V> innerMap;
    private final Class<? super K> outerKeyTypeToken;
    private final BiPredicate<? super K, ? super K> equals;
    private final ToIntFunction<? super K> hash;

    EqualityTransformingMap(Map<?, ?> innerMap, Class<? super K> outerKeyTypeToken, BiPredicate<? super K, ? super K> equals, ToIntFunction<? super K> hash) {
        assert (innerMap != null) : "The argument 'innerMap' must not be null.";
        assert (outerKeyTypeToken != null) : "The argument 'outerKeyTypeToken' must not be null.";
        assert (equals != null) : "The argument 'equals' must not be null.";
        assert (hash != null) : "The argument 'hash' must not be null.";
        this.innerMap = EqualityTransformingMap.castInnerMap(innerMap);
        this.outerKeyTypeToken = outerKeyTypeToken;
        this.equals = equals;
        this.hash = hash;
    }

    private static <K, V> Map<EqHash<K>, V> castInnerMap(Map<?, ?> untypedInnerMap) {
        Map<?, ?> innerMap = untypedInnerMap;
        return innerMap;
    }

    @Override
    protected Map<EqHash<K>, V> getInnerMap() {
        return this.innerMap;
    }

    @Override
    protected boolean isInnerKey(Object object) {
        return object instanceof EqHash;
    }

    @Override
    protected K transformToOuterKey(EqHash<K> innerKey) throws ClassCastException {
        return innerKey.getElement();
    }

    @Override
    protected boolean isOuterKey(Object object) {
        return object == null || this.outerKeyTypeToken.isInstance(object);
    }

    @Override
    protected EqHash<K> transformToInnerKey(K outerKey) throws ClassCastException {
        return EqHash.create(outerKey, this.equals, this.hash);
    }

    @Override
    protected boolean isInnerValue(Object object) {
        return true;
    }

    @Override
    protected V transformToOuterValue(V innerValue) throws ClassCastException {
        return innerValue;
    }

    @Override
    protected boolean isOuterValue(Object object) {
        return true;
    }

    @Override
    protected V transformToInnerValue(V outerValue) throws ClassCastException {
        return outerValue;
    }
}

