/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import org.codefx.libfx.collection.transform.EqualityTransformingMap;
import org.codefx.libfx.collection.transform.EqualityTransformingSet;

public class EqualityTransformingCollectionBuilder<E> {
    private final Class<? super E> outerKeyTypeToken;
    private BiPredicate<? super E, ? super E> equals;
    private ToIntFunction<? super E> hash;

    private EqualityTransformingCollectionBuilder(Class<? super E> outerKeyTypeToken) {
        this.outerKeyTypeToken = outerKeyTypeToken;
        this.equals = Objects::equals;
        this.hash = Objects::hashCode;
    }

    public static <E> EqualityTransformingCollectionBuilder<E> forType(Class<? super E> keyTypeToken) {
        Objects.requireNonNull(keyTypeToken, "The argument 'keyTypeToken' must not be null.");
        return new EqualityTransformingCollectionBuilder<E>(keyTypeToken);
    }

    public static <E> EqualityTransformingCollectionBuilder<E> forTypeUnknown() {
        return new EqualityTransformingCollectionBuilder<Object>(Object.class);
    }

    public EqualityTransformingCollectionBuilder<E> withEqualsHandlingNull(BiPredicate<? super E, ? super E> equals) {
        Objects.requireNonNull(equals, "The argument 'equals' must not be null.");
        this.equals = equals;
        return this;
    }

    public EqualityTransformingCollectionBuilder<E> withEquals(BiPredicate<? super E, ? super E> equals) {
        Objects.requireNonNull(equals, "The argument 'equals' must not be null.");
        return this.withEqualsHandlingNull(EqualityTransformingCollectionBuilder.makeNullSafe(equals));
    }

    private static <E> BiPredicate<? super E, ? super E> makeNullSafe(BiPredicate<? super E, ? super E> equals) {
        return (outerKey1, outerKey2) -> {
            if (outerKey1 == null && outerKey2 == null) {
                return true;
            }
            if (outerKey1 == null || outerKey2 == null) {
                return false;
            }
            return equals.test((Object)outerKey1, (Object)outerKey2);
        };
    }

    public EqualityTransformingCollectionBuilder<E> withHashHandlingNull(ToIntFunction<? super E> hash) {
        Objects.requireNonNull(hash, "The argument 'hash' must not be null.");
        this.hash = hash;
        return this;
    }

    public EqualityTransformingCollectionBuilder<E> withHash(ToIntFunction<? super E> hash) {
        Objects.requireNonNull(hash, "The argument 'hash' must not be null.");
        return this.withHashHandlingNull(EqualityTransformingCollectionBuilder.makeNullSafe(hash));
    }

    private static <E> ToIntFunction<? super E> makeNullSafe(ToIntFunction<? super E> hash) {
        return outerKey -> outerKey == null ? 0 : hash.applyAsInt((Object)outerKey);
    }

    public EqualityTransformingSet<E> buildSet() {
        return new EqualityTransformingSet<E>(new HashSet(), this.outerKeyTypeToken, this.equals, this.hash);
    }

    public EqualityTransformingSet<E> buildSet(Set<Object> emptySet) {
        return new EqualityTransformingSet<E>(emptySet, this.outerKeyTypeToken, this.equals, this.hash);
    }

    public <V> EqualityTransformingMap<E, V> buildMap() {
        return new EqualityTransformingMap(new HashMap(), this.outerKeyTypeToken, this.equals, this.hash);
    }

    public <V> EqualityTransformingMap<E, V> buildMap(Map<Object, Object> emptyMap) {
        return new EqualityTransformingMap(emptyMap, this.outerKeyTypeToken, this.equals, this.hash);
    }
}

