/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;

class EqHash<E> {
    public static final int NULL_KEY_HASH_CODE = 0;
    private final E element;
    private final BiPredicate<? super E, ? super E> equals;
    private final ToIntFunction<? super E> hash;

    private EqHash(E element, BiPredicate<? super E, ? super E> equals, ToIntFunction<? super E> hash) {
        assert (equals != null) : "The argument 'equals' must not be null.";
        assert (hash != null) : "The argument 'hash' must not be null.";
        this.element = element;
        this.equals = equals;
        this.hash = hash;
    }

    public static <E> EqHash<E> create(E element, BiPredicate<? super E, ? super E> equals, ToIntFunction<? super E> hash) {
        return new EqHash<E>(element, equals, hash);
    }

    public E getElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hash.applyAsInt(this.element);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EqHash)) {
            return false;
        }
        EqHash other = (EqHash)obj;
        return this.equals.test(this.element, other.element);
    }

    public String toString() {
        return "EqHash [" + this.element + "]";
    }
}

