/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefx.libfx.collection.transform.AbstractReadOnlyTransformingMap;
import org.codefx.libfx.collection.transform.AbstractTransformingCollection;
import org.codefx.libfx.collection.transform.AbstractTransformingSet;

abstract class AbstractTransformingMap<IK, OK, IV, OV>
implements Map<OK, OV> {
    private final Set<OK> outerKeys = new KeySetView();
    private final Collection<OV> outerValues = new ValueCollectionView();
    private final Set<Map.Entry<OK, OV>> outerEntries = new EntrySetView();

    protected AbstractTransformingMap() {
    }

    protected final boolean isThisMap(Map<?, ?> otherMap) {
        if (otherMap == this) {
            return true;
        }
        if (otherMap instanceof AbstractTransformingMap) {
            AbstractTransformingMap otherTransformingMap = (AbstractTransformingMap)otherMap;
            boolean sameInnerMap = otherTransformingMap.getInnerMap() == this.getInnerMap();
            return sameInnerMap;
        }
        return false;
    }

    @Override
    public int size() {
        return this.getInnerMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInnerMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isOuterKey(key)) {
            Object outerKey = key;
            return this.getInnerMap().containsKey(this.transformToInnerKey(outerKey));
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.isOuterValue(value)) {
            Object outerValue = value;
            return this.getInnerMap().containsValue(this.transformToInnerValue(outerValue));
        }
        return false;
    }

    @Override
    public OV get(Object key) {
        if (this.isOuterKey(key)) {
            Object outerKey = key;
            return this.transformToOuterValue(this.getInnerMap().get(this.transformToInnerKey(outerKey)));
        }
        return null;
    }

    @Override
    public OV getOrDefault(Object key, OV defaultValue) {
        if (this.isOuterKey(key)) {
            Object outerKey = key;
            return this.transformToOuterValue(this.getInnerMap().getOrDefault(this.transformToInnerKey(outerKey), this.transformToInnerValue(defaultValue)));
        }
        return defaultValue;
    }

    @Override
    public OV put(OK key, OV value) {
        return this.transformToOuterValue(this.getInnerMap().put(this.transformToInnerKey(key), this.transformToInnerValue(value)));
    }

    @Override
    public OV putIfAbsent(OK key, OV value) {
        return this.transformToOuterValue(this.getInnerMap().putIfAbsent(this.transformToInnerKey(key), this.transformToInnerValue(value)));
    }

    @Override
    public void putAll(Map<? extends OK, ? extends OV> outerMap) {
        Objects.requireNonNull(outerMap, "The argument 'outerMap' must not be null.");
        TransformToReadOnlyInnerMap asInner = new TransformToReadOnlyInnerMap(outerMap);
        this.getInnerMap().putAll(asInner);
    }

    @Override
    public OV compute(OK key, BiFunction<? super OK, ? super OV, ? extends OV> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "The argument 'remappingFunction' must not be null.");
        return this.transformToOuterValue(this.getInnerMap().compute(this.transformToInnerKey(key), this.transformToInnerKeyValueToValueFunction(remappingFunction)));
    }

    @Override
    public OV computeIfAbsent(OK key, Function<? super OK, ? extends OV> mappingFunction) {
        Objects.requireNonNull(mappingFunction, "The argument 'mappingFunction' must not be null.");
        return this.transformToOuterValue(this.getInnerMap().computeIfAbsent(this.transformToInnerKey(key), this.transformToInnerToKeyValueFunction(mappingFunction)));
    }

    @Override
    public OV computeIfPresent(OK key, BiFunction<? super OK, ? super OV, ? extends OV> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "The argument 'remappingFunction' must not be null.");
        return this.transformToOuterValue(this.getInnerMap().computeIfPresent(this.transformToInnerKey(key), this.transformToInnerKeyValueToValueFunction(remappingFunction)));
    }

    @Override
    public OV merge(OK key, OV value, BiFunction<? super OV, ? super OV, ? extends OV> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "The argument 'remappingFunction' must not be null.");
        return this.transformToOuterValue(this.getInnerMap().merge(this.transformToInnerKey(key), this.transformToInnerValue(value), this.transformToInnerValueValueToValueFunction(remappingFunction)));
    }

    @Override
    public OV replace(OK key, OV value) {
        return this.transformToOuterValue(this.getInnerMap().replace(this.transformToInnerKey(key), this.transformToInnerValue(value)));
    }

    @Override
    public boolean replace(OK key, OV oldValue, OV newValue) {
        return this.getInnerMap().replace(this.transformToInnerKey(key), this.transformToInnerValue(oldValue), this.transformToInnerValue(newValue));
    }

    @Override
    public void replaceAll(BiFunction<? super OK, ? super OV, ? extends OV> function) {
        Objects.requireNonNull(function, "The argument 'function' must not be null.");
        this.getInnerMap().replaceAll(this.transformToInnerKeyValueToValueFunction(function));
    }

    @Override
    public OV remove(Object key) {
        if (this.isOuterKey(key)) {
            Object outerKey = key;
            return this.transformToOuterValue(this.getInnerMap().remove(this.transformToInnerKey(outerKey)));
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.isOuterKey(key) && this.isOuterValue(value)) {
            Object outerKey = key;
            Object outerValue = value;
            return this.getInnerMap().remove(this.transformToInnerKey(outerKey), this.transformToInnerValue(outerValue));
        }
        return false;
    }

    @Override
    public void clear() {
        this.getInnerMap().clear();
    }

    @Override
    public void forEach(BiConsumer<? super OK, ? super OV> action) {
        Objects.requireNonNull(action, "The argument 'action' must not be null.");
        this.getInnerMap().forEach(this.transformToInnerKeyValueConsumer(action));
    }

    @Override
    public Set<OK> keySet() {
        return this.outerKeys;
    }

    @Override
    public Collection<OV> values() {
        return this.outerValues;
    }

    @Override
    public Set<Map.Entry<OK, OV>> entrySet() {
        return this.outerEntries;
    }

    private Function<? super IK, ? extends IV> transformToInnerToKeyValueFunction(Function<? super OK, ? extends OV> function) {
        return innerKey -> this.transformToInnerValue(function.apply((OK)this.transformToOuterKey(innerKey)));
    }

    private BiFunction<? super IK, ? super IV, ? extends IV> transformToInnerKeyValueToValueFunction(BiFunction<? super OK, ? super OV, ? extends OV> function) {
        return (innerKey, innerValue) -> this.transformToInnerValue(function.apply((OK)this.transformToOuterKey(innerKey), (OV)this.transformToOuterValue(innerValue)));
    }

    private BiFunction<? super IV, ? super IV, ? extends IV> transformToInnerValueValueToValueFunction(BiFunction<? super OV, ? super OV, ? extends OV> function) {
        return (innerValue1, innerValue2) -> this.transformToInnerValue(function.apply((OV)this.transformToOuterValue(innerValue1), (OV)this.transformToOuterValue(innerValue2)));
    }

    private BiConsumer<? super IK, ? super IV> transformToInnerKeyValueConsumer(BiConsumer<? super OK, ? super OV> consumer) {
        return (innerKey, innerValue) -> consumer.accept((OK)this.transformToOuterKey(innerKey), (OV)this.transformToOuterValue(innerValue));
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map other = (Map)object;
        if (this.isThisMap(other)) {
            return true;
        }
        return this.outerEntries.equals(other.entrySet());
    }

    @Override
    public final int hashCode() {
        return this.outerEntries.hashCode();
    }

    public String toString() {
        return this.outerEntries.stream().map(Objects::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    protected abstract Map<IK, IV> getInnerMap();

    protected abstract boolean isInnerKey(Object var1);

    protected abstract OK transformToOuterKey(IK var1) throws ClassCastException;

    protected abstract boolean isOuterKey(Object var1);

    protected abstract IK transformToInnerKey(OK var1) throws ClassCastException;

    protected abstract boolean isInnerValue(Object var1);

    protected abstract OV transformToOuterValue(IV var1) throws ClassCastException;

    protected abstract boolean isOuterValue(Object var1);

    protected abstract IV transformToInnerValue(OV var1) throws ClassCastException;

    private class TransformToReadOnlyInnerMap
    extends AbstractReadOnlyTransformingMap<OK, IK, OV, IV> {
        private final Map<? extends OK, ? extends OV> transformedMap;

        public TransformToReadOnlyInnerMap(Map<? extends OK, ? extends OV> transformedMap) {
            this.transformedMap = transformedMap;
        }

        @Override
        protected Map<OK, OV> getInnerMap() {
            Map unsafelyTypedMap = this.transformedMap;
            return unsafelyTypedMap;
        }

        @Override
        protected boolean isInnerKey(Object object) {
            return AbstractTransformingMap.this.isOuterKey(object);
        }

        @Override
        protected IK transformToOuterKey(OK innerKey) {
            return AbstractTransformingMap.this.transformToInnerKey(innerKey);
        }

        @Override
        protected boolean isOuterKey(Object object) {
            return AbstractTransformingMap.this.isInnerKey(object);
        }

        @Override
        protected OK transformToInnerKey(IK outerKey) {
            return AbstractTransformingMap.this.transformToOuterKey(outerKey);
        }

        @Override
        protected boolean isInnerValue(Object object) {
            return AbstractTransformingMap.this.isOuterValue(object);
        }

        @Override
        protected IV transformToOuterValue(OV innerValue) {
            return AbstractTransformingMap.this.transformToInnerValue(innerValue);
        }

        @Override
        protected boolean isOuterValue(Object object) {
            return AbstractTransformingMap.this.isInnerValue(object);
        }

        @Override
        protected OV transformToInnerValue(IV outerValue) {
            return AbstractTransformingMap.this.transformToOuterValue(outerValue);
        }
    }

    private class EntrySetView
    extends AbstractTransformingSet<Map.Entry<IK, IV>, Map.Entry<OK, OV>> {
        private EntrySetView() {
        }

        @Override
        protected Set<Map.Entry<IK, IV>> getInnerSet() {
            return AbstractTransformingMap.this.getInnerMap().entrySet();
        }

        @Override
        protected boolean isInnerElement(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractTransformingMap.this.isInnerKey(entry.getKey()) && AbstractTransformingMap.this.isInnerValue(entry.getValue());
        }

        @Override
        protected Map.Entry<OK, OV> transformToOuter(Map.Entry<IK, IV> innerElement) {
            Objects.requireNonNull(innerElement, "The argument 'innerElement' must not be null.");
            Object outerKey = AbstractTransformingMap.this.transformToOuterKey(innerElement.getKey());
            Object outerValue = AbstractTransformingMap.this.transformToOuterValue(innerElement.getValue());
            return new AbstractMap.SimpleEntry(outerKey, outerValue);
        }

        @Override
        protected boolean isOuterElement(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractTransformingMap.this.isOuterKey(entry.getKey()) && AbstractTransformingMap.this.isOuterValue(entry.getValue());
        }

        @Override
        protected Map.Entry<IK, IV> transformToInner(Map.Entry<OK, OV> outerElement) {
            if (outerElement == null) {
                return null;
            }
            Object innerKey = AbstractTransformingMap.this.transformToInnerKey(outerElement.getKey());
            Object innerValue = AbstractTransformingMap.this.transformToInnerValue(outerElement.getValue());
            return new AbstractMap.SimpleEntry(innerKey, innerValue);
        }

        @Override
        public boolean add(Map.Entry<OK, OV> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<OK, OV>> otherCollection) {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueCollectionView
    extends AbstractTransformingCollection<IV, OV> {
        private ValueCollectionView() {
        }

        @Override
        protected Collection<IV> getInnerCollection() {
            return AbstractTransformingMap.this.getInnerMap().values();
        }

        @Override
        protected boolean isInnerElement(Object object) {
            return AbstractTransformingMap.this.isInnerValue(object);
        }

        @Override
        protected OV transformToOuter(IV innerElement) {
            return AbstractTransformingMap.this.transformToOuterValue(innerElement);
        }

        @Override
        protected boolean isOuterElement(Object object) {
            return AbstractTransformingMap.this.isOuterValue(object);
        }

        @Override
        protected IV transformToInner(OV outerElement) {
            return AbstractTransformingMap.this.transformToInnerValue(outerElement);
        }

        @Override
        public boolean add(OV element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends OV> otherCollection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Collection)) {
                return false;
            }
            Collection other = (Collection)object;
            if (this.isThisCollection(other)) {
                return true;
            }
            return other.containsAll(this) && this.containsAll(other);
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Object outerElement : this) {
                hashCode = 31 * hashCode + (outerElement == null ? 0 : outerElement.hashCode());
            }
            return hashCode;
        }
    }

    private class KeySetView
    extends AbstractTransformingSet<IK, OK> {
        private KeySetView() {
        }

        @Override
        protected Set<IK> getInnerSet() {
            return AbstractTransformingMap.this.getInnerMap().keySet();
        }

        @Override
        protected boolean isInnerElement(Object object) {
            return AbstractTransformingMap.this.isInnerKey(object);
        }

        @Override
        protected OK transformToOuter(IK innerElement) {
            return AbstractTransformingMap.this.transformToOuterKey(innerElement);
        }

        @Override
        protected boolean isOuterElement(Object object) {
            return AbstractTransformingMap.this.isOuterKey(object);
        }

        @Override
        protected IK transformToInner(OK outerElement) {
            return AbstractTransformingMap.this.transformToInnerKey(outerElement);
        }

        @Override
        public boolean add(OK element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends OK> otherCollection) {
            throw new UnsupportedOperationException();
        }
    }
}

