/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.codefx.libfx.collection.transform.AbstractTransformingCollection;
import org.codefx.libfx.collection.transform.AbstractTransformingListIterator;

abstract class AbstractTransformingList<I, O>
extends AbstractTransformingCollection<I, O>
implements List<O> {
    AbstractTransformingList() {
    }

    @Override
    protected final Collection<I> getInnerCollection() {
        return this.getInnerList();
    }

    protected abstract List<I> getInnerList();

    @Override
    public O get(int index) {
        I innerElement = this.getInnerList().get(index);
        return this.transformToOuter(innerElement);
    }

    @Override
    public int indexOf(Object object) {
        if (this.isOuterElement(object)) {
            Object outerElement = object;
            Object innerElement = this.transformToInner(outerElement);
            return this.getInnerList().indexOf(innerElement);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (this.isOuterElement(object)) {
            Object outerElement = object;
            Object innerElement = this.transformToInner(outerElement);
            return this.getInnerList().lastIndexOf(innerElement);
        }
        return -1;
    }

    @Override
    public void add(int index, O element) {
        Object innerElement = this.transformToInner(element);
        this.getInnerList().add(index, innerElement);
    }

    @Override
    public boolean addAll(int index, Collection<? extends O> otherCollection) {
        Objects.requireNonNull(otherCollection, "The argument 'otherCollection' must not be null.");
        return this.callAddAllOnInner(index, otherCollection);
    }

    protected final boolean callAddAllOnInner(int startIndex, Collection<? extends O> otherCollection) {
        AbstractTransformingCollection.TransformToReadOnlyInnerCollection<? extends O> asInnerCollection = new AbstractTransformingCollection.TransformToReadOnlyInnerCollection<O>(otherCollection);
        return this.getInnerList().addAll(startIndex, asInnerCollection);
    }

    protected final boolean callAddOnThis(int startIndex, Collection<? extends O> otherCollection) {
        boolean changed = false;
        int currentIndex = startIndex;
        for (O entry : otherCollection) {
            this.add(currentIndex, entry);
            ++currentIndex;
            changed = true;
        }
        return changed;
    }

    @Override
    public O set(int index, O element) {
        Object innerElement = this.transformToInner(element);
        I formerInnerElement = this.getInnerList().set(index, innerElement);
        return this.transformToOuter(formerInnerElement);
    }

    @Override
    public void replaceAll(UnaryOperator<O> operator) {
        Objects.requireNonNull(operator, "The argument 'operator' must not be null.");
        UnaryOperator operatorOnInner = inner -> this.transformToInner(operator.apply(this.transformToOuter(inner)));
        this.getInnerList().replaceAll(operatorOnInner);
    }

    @Override
    public O remove(int index) {
        I removedInnerElement = this.getInnerList().remove(index);
        return this.transformToOuter(removedInnerElement);
    }

    @Override
    public void sort(Comparator<? super O> comparator) {
        Objects.requireNonNull(comparator, "The argument 'comparator' must not be null.");
        Comparator comparatorOfInner = (leftInner, rightInner) -> comparator.compare((O)this.transformToOuter(leftInner), (O)this.transformToOuter(rightInner));
        this.getInnerList().sort(comparatorOfInner);
    }

    @Override
    public ListIterator<O> listIterator() {
        return new ForwardingTransformingIterator();
    }

    @Override
    public ListIterator<O> listIterator(int startIndex) {
        return new ForwardingTransformingIterator(startIndex);
    }

    @Override
    public List<O> subList(int fromIndex, int toIndex) {
        return new ForwardingSubList(fromIndex, toIndex);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List other = (List)object;
        ListIterator<O> thisIterator = this.listIterator();
        ListIterator otherIterator = other.listIterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            if (Objects.equals(thisIterator.next(), otherIterator.next())) continue;
            return false;
        }
        return !thisIterator.hasNext() && !otherIterator.hasNext();
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        for (Object element : this) {
            hashCode = 31 * hashCode + (element == null ? 0 : element.hashCode());
        }
        return hashCode;
    }

    private class ForwardingSubList
    extends AbstractTransformingList<I, O> {
        private final List<I> innerSubList;

        public ForwardingSubList(int fromIndex, int toIndex) {
            this.innerSubList = AbstractTransformingList.this.getInnerList().subList(fromIndex, toIndex);
        }

        @Override
        protected List<I> getInnerList() {
            return this.innerSubList;
        }

        @Override
        protected boolean isInnerElement(Object object) {
            return AbstractTransformingList.this.isInnerElement(object);
        }

        @Override
        protected O transformToOuter(I innerElement) throws ClassCastException {
            return AbstractTransformingList.this.transformToOuter(innerElement);
        }

        @Override
        protected boolean isOuterElement(Object object) {
            return AbstractTransformingList.this.isOuterElement(object);
        }

        @Override
        protected I transformToInner(O outerElement) throws ClassCastException {
            return AbstractTransformingList.this.transformToInner(outerElement);
        }
    }

    private class ForwardingTransformingIterator
    extends AbstractTransformingListIterator<I, O> {
        private final ListIterator<I> innerIterator;

        public ForwardingTransformingIterator() {
            this.innerIterator = AbstractTransformingList.this.getInnerList().listIterator();
        }

        public ForwardingTransformingIterator(int startIndex) {
            this.innerIterator = AbstractTransformingList.this.getInnerList().listIterator(startIndex);
        }

        @Override
        protected ListIterator<I> getInnerIterator() {
            return this.innerIterator;
        }

        @Override
        protected O transformToOuter(I innerElement) {
            return AbstractTransformingList.this.transformToOuter(innerElement);
        }

        @Override
        protected I transformToInner(O outerElement) {
            return AbstractTransformingList.this.transformToInner(outerElement);
        }
    }
}

