/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.collection.transform;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codefx.libfx.collection.transform.AbstractReadOnlyTransformingCollection;
import org.codefx.libfx.collection.transform.AbstractTransformingIterator;
import org.codefx.libfx.collection.transform.AbstractTransformingSpliterator;

abstract class AbstractTransformingCollection<I, O>
implements Collection<O> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final String COLLECTION_TOO_LARGE_ERROR_MESSAGE = "Required array size too large";

    AbstractTransformingCollection() {
    }

    protected final boolean isThisCollection(Collection<?> otherCollection) {
        if (otherCollection == this) {
            return true;
        }
        if (otherCollection instanceof AbstractTransformingCollection) {
            AbstractTransformingCollection otherTransformingCollection = (AbstractTransformingCollection)otherCollection;
            boolean sameInnerCollection = otherTransformingCollection.getInnerCollection() == this.getInnerCollection();
            return sameInnerCollection;
        }
        return false;
    }

    @Override
    public int size() {
        return this.getInnerCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInnerCollection().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        if (this.isOuterElement(object)) {
            Object outerElement = object;
            I innerElement = this.transformToInner(outerElement);
            return this.getInnerCollection().contains(innerElement);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> otherCollection) {
        Objects.requireNonNull(otherCollection, "The argument 'otherCollection' must not be null.");
        if (this.isThisCollection(otherCollection)) {
            return true;
        }
        return this.callContainsAllOnInner(otherCollection);
    }

    protected final boolean callContainsAllOnInner(Collection<?> otherCollection) {
        TransformToReadOnlyInnerCollection asInnerCollection = new TransformToReadOnlyInnerCollection(otherCollection);
        return this.getInnerCollection().containsAll(asInnerCollection);
    }

    protected final boolean callContainsOnThis(Collection<?> otherCollection) {
        for (Object item : otherCollection) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(O element) {
        I innerElement = this.transformToInner(element);
        return this.getInnerCollection().add(innerElement);
    }

    @Override
    public boolean addAll(Collection<? extends O> otherCollection) {
        Objects.requireNonNull(otherCollection, "The argument 'otherCollection' must not be null.");
        return this.callAddAllOnInner(otherCollection);
    }

    protected final boolean callAddAllOnInner(Collection<? extends O> otherCollection) {
        TransformToReadOnlyInnerCollection<? extends O> asInnerCollection = new TransformToReadOnlyInnerCollection<O>(otherCollection);
        return this.getInnerCollection().addAll(asInnerCollection);
    }

    protected final boolean callAddOnThis(Collection<? extends O> otherCollection) {
        boolean changed = false;
        for (O entry : otherCollection) {
            changed |= this.add(entry);
        }
        return changed;
    }

    @Override
    public boolean remove(Object object) {
        if (this.isOuterElement(object)) {
            Object outerElement = object;
            I innerElement = this.transformToInner(outerElement);
            return this.getInnerCollection().remove(innerElement);
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super O> filter) {
        Objects.requireNonNull(filter, "The argument 'filter' must not be null.");
        Predicate<Object> innerFilter = innerElement -> {
            O outerElement = this.transformToOuter(innerElement);
            return filter.test((O)outerElement);
        };
        return this.getInnerCollection().removeIf(innerFilter);
    }

    @Override
    public boolean removeAll(Collection<?> otherCollection) {
        Objects.requireNonNull(otherCollection, "The argument 'otherCollection' must not be null.");
        if (this.isThisCollection(otherCollection)) {
            return this.clearToRemoveAll();
        }
        return this.callRemoveAllOnInner(otherCollection);
    }

    protected final boolean clearToRemoveAll() {
        if (this.size() == 0) {
            return false;
        }
        this.clear();
        return true;
    }

    protected final boolean callRemoveAllOnInner(Collection<?> otherCollection) {
        TransformToReadOnlyInnerCollection asInnerCollection = new TransformToReadOnlyInnerCollection(otherCollection);
        return this.getInnerCollection().removeAll(asInnerCollection);
    }

    protected final boolean callRemoveOnThis(Collection<?> otherCollection) {
        boolean changed = false;
        for (Object entry : otherCollection) {
            changed |= this.remove(entry);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> otherCollection) {
        Objects.requireNonNull(otherCollection, "The argument 'otherCollection' must not be null.");
        if (this.isThisCollection(otherCollection)) {
            return false;
        }
        return this.callRetainAllOnInner(otherCollection);
    }

    protected final boolean callRetainAllOnInner(Collection<?> otherCollection) {
        TransformToReadOnlyInnerCollection asInnerCollection = new TransformToReadOnlyInnerCollection(otherCollection);
        return this.getInnerCollection().retainAll(asInnerCollection);
    }

    protected final boolean retainByCallingRemoveOnThis(Collection<?> otherCollection) {
        boolean changed = false;
        Iterator<O> iterator = this.iterator();
        while (iterator.hasNext()) {
            O element = iterator.next();
            boolean remove = !otherCollection.contains(element);
            if (!remove) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.getInnerCollection().clear();
    }

    @Override
    public Iterator<O> iterator() {
        return new ForwardingTransformingIterator();
    }

    @Override
    public Spliterator<O> spliterator() {
        return new ForwardingTransformingSpliterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.createObjectArrayWithMapSize();
        int currentElementIndex = 0;
        for (O element : this) {
            array = AbstractTransformingCollection.provideArrayWithSufficientLength(array, currentElementIndex);
            array[currentElementIndex] = element;
            ++currentElementIndex;
        }
        return AbstractTransformingCollection.truncateArrayToLength(array, currentElementIndex);
    }

    private Object[] createObjectArrayWithMapSize() {
        int size = this.size();
        if (size > 0x7FFFFFF7) {
            throw new OutOfMemoryError(COLLECTION_TOO_LARGE_ERROR_MESSAGE);
        }
        return new Object[size];
    }

    private static <T> T[] provideArrayWithSufficientLength(T[] array, int minLength) {
        boolean arrayHasSufficientLength;
        boolean bl = arrayHasSufficientLength = minLength < array.length;
        if (arrayHasSufficientLength) {
            return array;
        }
        return AbstractTransformingCollection.copyToLargerArray(array);
    }

    private static <T> T[] copyToLargerArray(T[] array) {
        if (array.length == 0x7FFFFFF7) {
            throw new OutOfMemoryError(COLLECTION_TOO_LARGE_ERROR_MESSAGE);
        }
        int newSize = AbstractTransformingCollection.getIncreasedSize(array.length);
        return Arrays.copyOf(array, newSize);
    }

    private static int getIncreasedSize(int size) {
        boolean sizeWouldBeIncreasedAboveMaximum;
        boolean bl = sizeWouldBeIncreasedAboveMaximum = size >= 0x3FFFFFFB;
        if (sizeWouldBeIncreasedAboveMaximum) {
            return 0x7FFFFFF7;
        }
        return size + (size >>> 1) + 1;
    }

    private static <T> T[] truncateArrayToLength(T[] array, int length) {
        if (array.length == length) {
            return array;
        }
        return Arrays.copyOf(array, length);
    }

    @Override
    public <T> T[] toArray(T[] inputArray) {
        Objects.requireNonNull(inputArray, "The argument 'inputArray' must not be null.");
        T[] array = this.provideTypedArrayWithMapSize(inputArray);
        int currentElementIndex = 0;
        for (O element : this) {
            array = AbstractTransformingCollection.provideArrayWithSufficientLength(array, currentElementIndex);
            O unsafelyTypedElement = element;
            array[currentElementIndex] = unsafelyTypedElement;
            ++currentElementIndex;
        }
        return AbstractTransformingCollection.markOrTruncateArray(inputArray, array, currentElementIndex);
    }

    private <T> T[] provideTypedArrayWithMapSize(T[] inputArray) {
        boolean arrayHasSufficientLength;
        int size = this.size();
        boolean bl = arrayHasSufficientLength = size <= inputArray.length;
        if (arrayHasSufficientLength) {
            return inputArray;
        }
        if (size > 0x7FFFFFF7) {
            throw new OutOfMemoryError(COLLECTION_TOO_LARGE_ERROR_MESSAGE);
        }
        Object[] array = (Object[])Array.newInstance(inputArray.getClass().getComponentType(), size);
        return array;
    }

    private static <T> T[] markOrTruncateArray(T[] inputArray, T[] array, int nrOfElements) {
        boolean usingInputArray;
        boolean bl = usingInputArray = array == inputArray;
        if (usingInputArray) {
            return AbstractTransformingCollection.markEndWithNull(array, nrOfElements);
        }
        return AbstractTransformingCollection.truncateArrayToLength(array, nrOfElements);
    }

    private static <T> T[] markEndWithNull(T[] array, int nullIndex) {
        if (nullIndex < array.length) {
            array[nullIndex] = null;
        }
        return array;
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    public String toString() {
        return this.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    protected abstract Collection<I> getInnerCollection();

    protected abstract boolean isInnerElement(Object var1);

    protected abstract O transformToOuter(I var1) throws ClassCastException;

    protected abstract boolean isOuterElement(Object var1);

    protected abstract I transformToInner(O var1) throws ClassCastException;

    protected final class TransformToReadOnlyInnerCollection<E>
    extends AbstractReadOnlyTransformingCollection<E, I> {
        private final Collection<E> transformedCollection;

        public TransformToReadOnlyInnerCollection(Collection<E> transformedCollection) {
            assert (transformedCollection != null) : "The argument 'innerCollection' must not be null.";
            this.transformedCollection = transformedCollection;
        }

        @Override
        protected Collection<E> getInnerCollection() {
            return this.transformedCollection;
        }

        @Override
        protected boolean isInnerElement(Object object) {
            return AbstractTransformingCollection.this.isOuterElement(object);
        }

        @Override
        protected I transformToOuter(E innerElement) {
            E asClientOuterElement = innerElement;
            return AbstractTransformingCollection.this.transformToInner(asClientOuterElement);
        }

        @Override
        protected boolean isOuterElement(Object object) {
            return AbstractTransformingCollection.this.isInnerElement(object);
        }

        @Override
        protected E transformToInner(I outerElement) {
            Object transformedToClientOuterElement;
            Object asThisInnerElement = transformedToClientOuterElement = AbstractTransformingCollection.this.transformToOuter(outerElement);
            return (E)asThisInnerElement;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Collection)) {
                return false;
            }
            Collection other = (Collection)object;
            if (this.isThisCollection(other)) {
                return true;
            }
            return other.containsAll(this) && this.containsAll(other);
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Object clientInnerElement : this) {
                hashCode = 31 * hashCode + (clientInnerElement == null ? 0 : clientInnerElement.hashCode());
            }
            return hashCode;
        }
    }

    private class ForwardingTransformingSpliterator
    extends AbstractTransformingSpliterator<I, O> {
        private final Spliterator<I> innerSpliterator;

        private ForwardingTransformingSpliterator() {
            this.innerSpliterator = AbstractTransformingCollection.this.getInnerCollection().spliterator();
        }

        @Override
        protected Spliterator<I> getInnerSpliterator() {
            return this.innerSpliterator;
        }

        @Override
        protected O transformToOuter(I innerElement) {
            return AbstractTransformingCollection.this.transformToOuter(innerElement);
        }

        @Override
        protected I transformToInner(O outerElement) {
            return AbstractTransformingCollection.this.transformToInner(outerElement);
        }

        @Override
        protected Spliterator<O> wrapNewSpliterator(Spliterator<I> newSpliterator) {
            return new ForwardingTransformingSpliterator();
        }
    }

    private class ForwardingTransformingIterator
    extends AbstractTransformingIterator<I, O> {
        private final Iterator<I> innerIterator;

        private ForwardingTransformingIterator() {
            this.innerIterator = AbstractTransformingCollection.this.getInnerCollection().iterator();
        }

        @Override
        protected Iterator<I> getInnerIterator() {
            return this.innerIterator;
        }

        @Override
        protected O transformToOuter(I innerElement) {
            return AbstractTransformingCollection.this.transformToOuter(innerElement);
        }
    }
}

