/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.listener.handle;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.codefx.libfx.listener.handle.ListenerHandle;

final class GenericListenerHandle<O, L>
implements ListenerHandle {
    private final O observable;
    private final L listener;
    private final BiConsumer<? super O, ? super L> add;
    private final BiConsumer<? super O, ? super L> remove;
    private boolean attached;

    public GenericListenerHandle(O observable, L listener, BiConsumer<? super O, ? super L> add, BiConsumer<? super O, ? super L> remove) {
        Objects.requireNonNull(observable, "The argument 'observable' must not be null.");
        Objects.requireNonNull(listener, "The argument 'listener' must not be null.");
        Objects.requireNonNull(add, "The argument 'add' must not be null.");
        Objects.requireNonNull(remove, "The argument 'remove' must not be null.");
        this.observable = observable;
        this.listener = listener;
        this.add = add;
        this.remove = remove;
    }

    @Override
    public void attach() {
        if (this.attached) {
            return;
        }
        this.attached = true;
        this.add.accept(this.observable, this.listener);
    }

    @Override
    public void detach() {
        if (!this.attached) {
            return;
        }
        this.attached = false;
        this.remove.accept(this.observable, this.listener);
    }
}

