/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting.listener;

import java.util.Objects;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.codefx.libfx.nesting.Nesting;
import org.codefx.libfx.nesting.NestingObserver;
import org.codefx.libfx.nesting.listener.NestedListenerHandle;

public class NestedInvalidationListenerHandle
implements NestedListenerHandle {
    private final Nesting<? extends Observable> nesting;
    private final BooleanProperty innerObservablePresent;
    private final InvalidationListener listener;
    private boolean attached;

    NestedInvalidationListenerHandle(Nesting<? extends Observable> nesting, InvalidationListener listener) {
        Objects.requireNonNull(nesting, "The argument 'nesting' must not be null.");
        Objects.requireNonNull(listener, "The argument 'listener' must not be null.");
        this.nesting = nesting;
        this.innerObservablePresent = new SimpleBooleanProperty((Object)this, "innerObservablePresent");
        this.listener = listener;
        NestingObserver.forNesting(nesting).withOldInnerObservable(this::remove).withNewInnerObservable(this::addIfAttached).whenInnerObservableChanges((any, newInnerObservablePresent) -> this.innerObservablePresent.set(newInnerObservablePresent.booleanValue())).observe();
    }

    private void addIfAttached(Observable observable) {
        if (this.attached) {
            observable.addListener(this.listener);
        }
    }

    private void remove(Observable observable) {
        observable.removeListener(this.listener);
    }

    @Override
    public void attach() {
        if (!this.attached) {
            this.attached = true;
            ((Optional)this.nesting.innerObservableProperty().getValue()).ifPresent(this::addIfAttached);
        }
    }

    @Override
    public void detach() {
        if (this.attached) {
            this.attached = false;
            ((Optional)this.nesting.innerObservableProperty().getValue()).ifPresent(this::remove);
        }
    }

    @Override
    public ReadOnlyBooleanProperty innerObservablePresentProperty() {
        return this.innerObservablePresent;
    }

    @Override
    public boolean isInnerObservablePresent() {
        return this.innerObservablePresent.get();
    }
}

