/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.Observable;
import org.codefx.libfx.nesting.Nesting;

public final class NestingObserver<O extends Observable> {
    private final Nesting<? extends O> nesting;
    private final Consumer<? super O> oldInnerObservableConsumer;
    private final Consumer<? super O> newInnerObservableConsumer;
    private final BiConsumer<Boolean, Boolean> innerObservableChanges;

    private NestingObserver(NestingObserverBuilder<O> builder) {
        this.nesting = ((NestingObserverBuilder)builder).nesting;
        this.oldInnerObservableConsumer = ((NestingObserverBuilder)builder).oldInnerObservableConsumer;
        this.newInnerObservableConsumer = ((NestingObserverBuilder)builder).newInnerObservableConsumer;
        this.innerObservableChanges = ((NestingObserverBuilder)builder).innerObservableChanges;
        this.initializeObserver();
    }

    public static <O extends Observable> NestingObserverBuilder<O> forNesting(Nesting<O> nesting) {
        return new NestingObserverBuilder(nesting);
    }

    private void initializeObserver() {
        this.observeInnerObservableChange(Optional.empty(), (Optional)this.nesting.innerObservableProperty().getValue());
        this.nesting.innerObservableProperty().addListener((o, oldInnerObservable, newInnerObservable) -> this.observeInnerObservableChange((Optional<? extends O>)oldInnerObservable, (Optional<? extends O>)newInnerObservable));
    }

    private void observeInnerObservableChange(Optional<? extends O> oldInnerObservable, Optional<? extends O> newInnerObservable) {
        oldInnerObservable.ifPresent(oldObservable -> this.oldInnerObservableConsumer.accept(oldObservable));
        newInnerObservable.ifPresent(newObservable -> this.newInnerObservableConsumer.accept(newObservable));
        boolean oldInnerObservablePresent = oldInnerObservable.isPresent();
        boolean newInnerObservablePresent = newInnerObservable.isPresent();
        this.innerObservableChanges.accept(oldInnerObservablePresent, newInnerObservablePresent);
    }

    public static class NestingObserverBuilder<O extends Observable> {
        private final Nesting<? extends O> nesting;
        private Consumer<? super O> oldInnerObservableConsumer;
        private Consumer<? super O> newInnerObservableConsumer;
        private BiConsumer<Boolean, Boolean> innerObservableChanges;

        private NestingObserverBuilder(Nesting<? extends O> nesting) {
            this.nesting = nesting;
            this.oldInnerObservableConsumer = observable -> {};
            this.newInnerObservableConsumer = observable -> {};
            this.innerObservableChanges = (oldObservablePresent, newObservablePresent) -> {};
        }

        public NestingObserverBuilder<O> withOldInnerObservable(Consumer<? super O> oldInnerObservableConsumer) {
            this.oldInnerObservableConsumer = oldInnerObservableConsumer;
            return this;
        }

        public NestingObserverBuilder<O> withNewInnerObservable(Consumer<? super O> newInnerObservableConsumer) {
            this.newInnerObservableConsumer = newInnerObservableConsumer;
            return this;
        }

        public NestingObserverBuilder<O> whenInnerObservableChanges(BiConsumer<Boolean, Boolean> innerObservableChanges) {
            this.innerObservableChanges = innerObservableChanges;
            return this;
        }

        public void observe() {
            NestingObserver observer = new NestingObserver(this);
        }
    }
}

