/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.codefx.libfx.nesting.Nesting;
import org.codefx.libfx.nesting.NestingStep;

final class DeepNesting<O extends Observable>
implements Nesting<O> {
    private final int maxLevel;
    private final NestingStep[] nestingSteps;
    private final ObservableValue[] observables;
    private final Object[] values;
    private final ChangeListener[] changeListeners;
    private final Property<Optional<O>> inner;

    public DeepNesting(ObservableValue outerObservable, List<NestingStep> nestingSteps) {
        Objects.requireNonNull(outerObservable, "The argument 'outerObservable' must not be null.");
        Objects.requireNonNull(nestingSteps, "The argument 'nestedObservableGetters' must not be null.");
        if (nestingSteps.size() < 1) {
            throw new IllegalArgumentException("The list 'nestedObservableGetters' must have at least length 1.");
        }
        this.maxLevel = nestingSteps.size();
        this.observables = DeepNesting.createObservables(outerObservable, this.maxLevel);
        this.values = new Object[this.maxLevel];
        this.nestingSteps = nestingSteps.toArray(new NestingStep[this.maxLevel]);
        this.changeListeners = this.createChangeListeners(this.maxLevel);
        this.inner = new SimpleObjectProperty((Object)this, "inner");
        this.initializeNesting();
    }

    private static ObservableValue[] createObservables(ObservableValue outerObservable, int levels) {
        ObservableValue[] observables = new ObservableValue[levels];
        observables[0] = outerObservable;
        return observables;
    }

    private ChangeListener[] createChangeListeners(int levels) {
        ChangeListener[] listeners = new ChangeListener[levels];
        for (int level = 0; level < levels; ++level) {
            int theLevel = level;
            listeners[level] = (observable, oldValue, newValue) -> this.updateNestingFromLevel(theLevel);
        }
        return listeners;
    }

    private void initializeNesting() {
        new NestingInitializer().initialize();
    }

    private void updateNestingFromLevel(int startLevel) {
        new NestingUpdater(startLevel).update();
    }

    @Override
    public ReadOnlyProperty<Optional<O>> innerObservableProperty() {
        return this.inner;
    }

    private class NestingUpdater {
        private int currentLevel;
        private boolean currentLevelIsInnerLevel;
        private ObservableValue currentObservable;
        private Object currentValue;
        private boolean currentValueChanged;
        private Observable innerObservable;

        public NestingUpdater(int startLevel) {
            this.currentLevel = startLevel;
            this.currentLevelIsInnerLevel = false;
            this.currentObservable = DeepNesting.this.observables[startLevel];
            this.currentValue = this.currentObservable.getValue();
            this.currentValueChanged = DeepNesting.this.values[this.currentLevel] != this.currentObservable.getValue();
        }

        public void update() {
            while (this.mustUpdateCurrentLevel()) {
                this.updateCurrentLevel();
                this.moveToNextLevel();
            }
            this.updateInnerObservable();
        }

        private boolean mustUpdateCurrentLevel() {
            return this.currentValueChanged && !this.currentLevelIsInnerLevel;
        }

        private void updateCurrentLevel() {
            this.updateObservableOnCurrentLevel();
            this.updateValueOnCurrentLevel();
        }

        private void updateObservableOnCurrentLevel() {
            ObservableValue storedObservable = DeepNesting.this.observables[this.currentLevel];
            if (storedObservable != this.currentObservable) {
                ((DeepNesting)DeepNesting.this).observables[this.currentLevel] = this.currentObservable;
                if (storedObservable != null) {
                    storedObservable.removeListener(DeepNesting.this.changeListeners[this.currentLevel]);
                }
                if (this.currentObservable != null) {
                    this.currentObservable.addListener(DeepNesting.this.changeListeners[this.currentLevel]);
                }
            }
        }

        private void updateValueOnCurrentLevel() {
            this.currentValue = this.currentObservable == null ? null : this.currentObservable.getValue();
            Object storedValue = DeepNesting.this.values[this.currentLevel];
            boolean bl = this.currentValueChanged = storedValue != this.currentValue;
            if (this.currentValueChanged) {
                ((DeepNesting)DeepNesting.this).values[this.currentLevel] = this.currentValue;
            }
        }

        private void moveToNextLevel() {
            boolean nextIsInnerLevel;
            Object nextObservable = null;
            if (this.currentValue != null) {
                nextObservable = DeepNesting.this.nestingSteps[this.currentLevel].step(this.currentValue);
            }
            boolean bl = nextIsInnerLevel = this.currentLevel + 1 == DeepNesting.this.maxLevel;
            if (nextIsInnerLevel) {
                this.currentLevelIsInnerLevel = true;
                this.innerObservable = nextObservable;
            } else {
                this.currentLevelIsInnerLevel = false;
                this.currentObservable = nextObservable;
            }
            ++this.currentLevel;
        }

        private void updateInnerObservable() {
            if (this.currentLevelIsInnerLevel) {
                Optional<Observable> innerObservableOptional = Optional.ofNullable(this.innerObservable);
                DeepNesting.this.inner.setValue(innerObservableOptional);
            }
        }
    }

    private class NestingInitializer {
        private NestingInitializer() {
        }

        public void initialize() {
            DeepNesting.this.observables[0].addListener(DeepNesting.this.changeListeners[0]);
            new NestingUpdater(0).update();
        }
    }
}

