/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.listener.handle;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.codefx.libfx.listener.handle.GenericListenerHandle;
import org.codefx.libfx.listener.handle.ListenerHandle;

public final class ListenerHandleBuilder<O, L> {
    private final O observable;
    private final L listener;
    private Optional<BiConsumer<? super O, ? super L>> add;
    private Optional<BiConsumer<? super O, ? super L>> remove;

    private ListenerHandleBuilder(O observable, L listener) {
        Objects.requireNonNull(observable, "The argument 'observable' must not be null.");
        Objects.requireNonNull(listener, "The argument 'listener' must not be null.");
        this.observable = observable;
        this.listener = listener;
        this.add = Optional.empty();
        this.remove = Optional.empty();
    }

    public static <O, L> ListenerHandleBuilder<O, L> from(O observable, L listener) {
        return new ListenerHandleBuilder<O, L>(observable, listener);
    }

    public ListenerHandleBuilder<O, L> onAttach(BiConsumer<? super O, ? super L> add) {
        Objects.requireNonNull(add, "The argument 'add' must not be null.");
        this.add = Optional.of(add);
        return this;
    }

    public ListenerHandleBuilder<O, L> onDetach(BiConsumer<? super O, ? super L> remove) {
        Objects.requireNonNull(remove, "The argument 'remove' must not be null.");
        this.remove = Optional.of(remove);
        return this;
    }

    public ListenerHandle buildAttached() throws IllegalStateException {
        ListenerHandle handle = this.buildDetached();
        handle.attach();
        return handle;
    }

    public ListenerHandle buildDetached() throws IllegalStateException {
        this.verifyAddAndRemovePresent();
        return new GenericListenerHandle<O, L>(this.observable, this.listener, this.add.get(), this.remove.get());
    }

    private void verifyAddAndRemovePresent() throws IllegalStateException {
        boolean canBuild;
        boolean onAttachNotCalled = !this.add.isPresent();
        boolean onDetachNotCalled = !this.remove.isPresent();
        boolean bl = canBuild = !onAttachNotCalled && !onDetachNotCalled;
        if (canBuild) {
            return;
        }
        ListenerHandleBuilder.throwExceptionForMissingCall(onAttachNotCalled, onDetachNotCalled);
    }

    private static void throwExceptionForMissingCall(boolean onAttachNotCalled, boolean onDetachNotCalled) throws IllegalStateException {
        if (onAttachNotCalled && onDetachNotCalled) {
            throw new IllegalStateException("A listener handle can not be build until 'onAttach' and 'onDetach' have been called.");
        }
        if (onAttachNotCalled) {
            throw new IllegalStateException("A listener handle can not be build until 'onAttach' has been called.");
        }
        if (onDetachNotCalled) {
            throw new IllegalStateException("A listener handle can not be build until 'onDetach' has been called.");
        }
    }
}

