/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.dom;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import javax.swing.event.HyperlinkEvent;
import org.codefx.libfx.dom.DomEventType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

class SingleDomEventConverter {
    private final Event domEvent;
    private final Object source;

    public SingleDomEventConverter(Event domEvent, Object source) {
        Objects.requireNonNull(domEvent, "The argument 'domEvent' must not be null.");
        Objects.requireNonNull(source, "The argument 'source' must not be null.");
        this.domEvent = domEvent;
        this.source = source;
    }

    public boolean canConvert() {
        Optional<HyperlinkEvent.EventType> eventType = SingleDomEventConverter.getEventTypeFrom(this.domEvent);
        return eventType.isPresent();
    }

    private static Optional<HyperlinkEvent.EventType> getEventTypeFrom(Event domEvent) {
        String domEventName = domEvent.getType();
        Optional<HyperlinkEvent.EventType> eventType = DomEventType.byName(domEventName).flatMap(domEventType -> domEventType.toHyperlinkEventType());
        return eventType;
    }

    public HyperlinkEvent convert() throws IllegalArgumentException {
        HyperlinkEvent.EventType type = this.getEventTypeForDomEvent();
        Optional<URL> url = this.getURL();
        String linkDescription = this.getTextContent();
        return new HyperlinkEvent(this.source, type, url.orElse(null), linkDescription);
    }

    private HyperlinkEvent.EventType getEventTypeForDomEvent() throws IllegalArgumentException {
        Optional<HyperlinkEvent.EventType> eventType = SingleDomEventConverter.getEventTypeFrom(this.domEvent);
        if (eventType.isPresent()) {
            return eventType.get();
        }
        throw new IllegalArgumentException("The DOM event '" + this.domEvent + "' of type '" + this.domEvent.getType() + "' can not be converted to a hyperlink event.");
    }

    private String getTextContent() {
        Element targetElement = (Element)((Object)this.domEvent.getTarget());
        return targetElement.getTextContent();
    }

    private Optional<URL> getURL() {
        Element targetElement = (Element)((Object)this.domEvent.getTarget());
        Element anchor = SingleDomEventConverter.getAnchor(targetElement);
        Optional<String> baseURI = Optional.ofNullable(anchor.getBaseURI());
        String href = anchor.getAttribute("href");
        return SingleDomEventConverter.createURL(baseURI, href);
    }

    private static Element getAnchor(Element domElement) throws IllegalArgumentException {
        Optional<Element> anchor = SingleDomEventConverter.getAnchorAncestor(Optional.of(domElement));
        return anchor.orElseThrow(() -> new IllegalArgumentException("Neither the event's target element nor one of its parent nodes is an anchor."));
    }

    private static Optional<Element> getAnchorAncestor(Optional<Node> domNode) {
        boolean nodeIsNoElement;
        if (!domNode.isPresent()) {
            return Optional.empty();
        }
        Node node = domNode.get();
        boolean bl = nodeIsNoElement = !(node instanceof Element);
        if (nodeIsNoElement) {
            return SingleDomEventConverter.getAnchorAncestor(Optional.ofNullable(node.getParentNode()));
        }
        Element element = (Element)node;
        boolean isAnchor = element.getTagName().equalsIgnoreCase("a");
        if (isAnchor) {
            return Optional.of(element);
        }
        return SingleDomEventConverter.getAnchorAncestor(Optional.ofNullable(element.getParentNode()));
    }

    private static Optional<URL> createURL(Optional<String> baseURI, String href) {
        URL context = null;
        try {
            if (baseURI.isPresent()) {
                context = new URL(baseURI.get());
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            URL url = new URL(context, href);
            return Optional.of(url);
        }
        catch (MalformedURLException malformedURLException) {
            return Optional.empty();
        }
    }
}

