/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.dom;

import java.util.Objects;
import java.util.Optional;
import javax.swing.event.HyperlinkEvent;

public enum DomEventType {
    CLICK("click"),
    MOUSE_ENTER("mouseenter"),
    MOUSE_LEAVE("mouseleave");

    private final String domName;

    private DomEventType(String domName) {
        this.domName = domName;
    }

    public String getDomName() {
        return this.domName;
    }

    public static Optional<DomEventType> byName(String domEventName) {
        Objects.requireNonNull(domEventName, "The argument 'domEventName' must not be null.");
        for (DomEventType type : DomEventType.values()) {
            if (!type.getDomName().equals(domEventName)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public Optional<HyperlinkEvent.EventType> toHyperlinkEventType() {
        switch (this) {
            case CLICK: {
                return Optional.of(HyperlinkEvent.EventType.ACTIVATED);
            }
            case MOUSE_ENTER: {
                return Optional.of(HyperlinkEvent.EventType.ENTERED);
            }
            case MOUSE_LEAVE: {
                return Optional.of(HyperlinkEvent.EventType.EXITED);
            }
        }
        return Optional.empty();
    }
}

