/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.control.properties;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.collections.ObservableMap;
import org.codefx.libfx.control.properties.AbstractControlPropertyListenerHandle;

final class TypeCheckingControlPropertyListenerHandle<T>
extends AbstractControlPropertyListenerHandle {
    private final Class<T> valueType;
    private final Consumer<? super T> valueProcessor;

    TypeCheckingControlPropertyListenerHandle(ObservableMap<Object, Object> properties, Object key, Class<T> valueType, Consumer<? super T> valueProcessor) {
        super(properties, key);
        Objects.requireNonNull(valueProcessor, "The argument 'valueProcessor' must not be null.");
        Objects.requireNonNull(valueType, "The argument 'valueType' must not be null.");
        this.valueType = valueType;
        this.valueProcessor = valueProcessor;
    }

    @Override
    protected boolean processValueIfPossible(Object value) {
        boolean valueHasCorrectType = this.valueType.isInstance(value);
        if (valueHasCorrectType) {
            Object convertedValue = value;
            this.valueProcessor.accept(convertedValue);
            return true;
        }
        return false;
    }
}

