/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.control.properties;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.collections.ObservableMap;
import org.codefx.libfx.control.properties.CastingControlPropertyListenerHandle;
import org.codefx.libfx.control.properties.ControlPropertyListenerHandle;
import org.codefx.libfx.control.properties.TypeCheckingControlPropertyListenerHandle;

public class ControlPropertyListenerBuilder<T> {
    private final ObservableMap<Object, Object> properties;
    private Object key;
    private Consumer<? super T> valueProcessor;
    private Optional<Class<T>> valueType;

    private ControlPropertyListenerBuilder(ObservableMap<Object, Object> properties) {
        Objects.requireNonNull(properties, "The argument 'properties' must not be null.");
        this.properties = properties;
        this.valueType = Optional.empty();
    }

    public static <T> ControlPropertyListenerBuilder<T> on(ObservableMap<Object, Object> properties) {
        return new ControlPropertyListenerBuilder<T>(properties);
    }

    public ControlPropertyListenerBuilder<T> forKey(Object key) {
        Objects.requireNonNull(key, "The argument 'key' must not be null.");
        this.key = key;
        return this;
    }

    public ControlPropertyListenerBuilder<T> forValueType(Class<T> valueType) {
        Objects.requireNonNull(valueType, "The argument 'valueType' must not be null.");
        this.valueType = Optional.of(valueType);
        return this;
    }

    public ControlPropertyListenerBuilder<T> processValue(Consumer<? super T> valueProcessor) {
        Objects.requireNonNull(valueProcessor, "The argument 'valueProcessor' must not be null.");
        this.valueProcessor = valueProcessor;
        return this;
    }

    public ControlPropertyListenerHandle buildAttached() {
        ControlPropertyListenerHandle listener = this.buildDetached();
        listener.attach();
        return listener;
    }

    public ControlPropertyListenerHandle buildDetached() {
        this.checkFields();
        if (this.valueType.isPresent()) {
            return new TypeCheckingControlPropertyListenerHandle<T>(this.properties, this.key, this.valueType.get(), this.valueProcessor);
        }
        return new CastingControlPropertyListenerHandle<T>(this.properties, this.key, this.valueProcessor);
    }

    private void checkFields() {
        if (this.key == null) {
            throw new IllegalStateException("Set a key with 'forKey' before calling 'build'.");
        }
        if (this.valueProcessor == null) {
            throw new IllegalStateException("Set a value processor with 'processValue' before calling 'build'.");
        }
    }
}

