/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.control.properties;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.collections.ObservableMap;
import org.codefx.libfx.control.properties.AbstractControlPropertyListenerHandle;

final class CastingControlPropertyListenerHandle<T>
extends AbstractControlPropertyListenerHandle {
    private final Consumer<? super T> valueProcessor;

    CastingControlPropertyListenerHandle(ObservableMap<Object, Object> properties, Object key, Consumer<? super T> valueProcessor) {
        super(properties, key);
        Objects.requireNonNull(valueProcessor, "The argument 'valueProcessor' must not be null.");
        this.valueProcessor = valueProcessor;
    }

    @Override
    protected boolean processValueIfPossible(Object value) {
        try {
            Object convertedValue = value;
            this.valueProcessor.accept(convertedValue);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

