/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.control.properties;

import java.util.Objects;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import org.codefx.libfx.control.properties.ControlPropertyListenerHandle;

abstract class AbstractControlPropertyListenerHandle
implements ControlPropertyListenerHandle {
    private final ObservableMap<Object, Object> properties;
    private final Object key;
    private final MapChangeListener<Object, Object> listener;
    private boolean attached;

    protected AbstractControlPropertyListenerHandle(ObservableMap<Object, Object> properties, Object key) {
        Objects.requireNonNull(properties, "The argument 'properties' must not be null.");
        Objects.requireNonNull(key, "The argument 'key' must not be null.");
        this.properties = properties;
        this.key = key;
        this.listener = this.createListener(key);
    }

    private MapChangeListener<Object, Object> createListener(Object key) {
        return change -> {
            boolean setForCorrectKey;
            boolean bl = setForCorrectKey = change.wasAdded() && Objects.equals(key, change.getKey());
            if (setForCorrectKey) {
                this.processAndRemoveValue(change.getValueAdded());
            }
        };
    }

    private void processAndRemoveValue(Object value) {
        this.processValueIfPossible(value);
        this.properties.remove(this.key);
    }

    protected abstract boolean processValueIfPossible(Object var1);

    @Override
    public void attach() {
        if (this.attached) {
            return;
        }
        this.attached = true;
        this.properties.addListener(this.listener);
        if (this.properties.containsKey(this.key)) {
            this.processAndRemoveValue(this.properties.get(this.key));
        }
    }

    @Override
    public void detach() {
        this.attached = false;
        this.properties.removeListener(this.listener);
    }
}

