/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.services;

import javax.inject.Inject;
import javax.inject.Named;
import org.cloudfoundry.multiapps.controller.persistence.services.ProcessLogger;
import org.cloudfoundry.multiapps.controller.persistence.services.ProcessLoggerProvider;
import org.cloudfoundry.multiapps.controller.persistence.services.ProcessLogsPersistenceService;
import org.springframework.scheduling.annotation.Async;

@Named(value="processLogsPersister")
public class ProcessLogsPersister {
    @Inject
    private ProcessLoggerProvider processLoggerProvider;
    @Inject
    private ProcessLogsPersistenceService processLogsPersistenceService;

    @Async(value="asyncExecutor")
    public void persistLogs(String correlationId, String taskId) {
        for (ProcessLogger processLogger : this.processLoggerProvider.getExistingLoggers(correlationId, taskId)) {
            processLogger.persistLogFile(this.processLogsPersistenceService);
            processLogger.deleteLogFile();
            this.processLoggerProvider.remove(processLogger);
        }
    }
}

