/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.jclouds.providers.aliyun.blobstore;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cloudfoundry.multiapps.common.SLException;
import org.cloudfoundry.multiapps.controller.persistence.jclouds.providers.aliyun.AliOSSApi;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.domain.Location;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.location.suppliers.LocationsSupplier;

@Singleton
public class AliOSSBlobStore
extends BaseBlobStore {
    private final AliOSSApi aliOSSApi;

    @Inject
    protected AliOSSBlobStore(AliOSSApi aliOSSApi, BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, LocationsSupplier locations, PayloadSlicer slicer) {
        super(context, blobUtils, defaultLocation, (Supplier)locations, slicer);
        this.aliOSSApi = aliOSSApi;
    }

    public boolean containerExists(String container) {
        return this.doOssOperation(oss -> oss.doesBucketExist(container));
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        return (PageSet)this.doOssOperation(oss -> {
            ListObjectsRequest request = this.toListObjectRequest(container, options);
            ObjectListing objectListing = oss.listObjects(request);
            List<StorageMetadata> storageMetadataList = this.toStorageMetadataList((OSS)oss, container, objectListing);
            return new PageSetImpl(storageMetadataList, objectListing.getNextMarker());
        });
    }

    public boolean blobExists(String container, String name) {
        return this.doOssOperation(oss -> oss.doesObjectExist(container, name));
    }

    public String putBlob(String container, Blob blob) {
        return this.doOssOperation(oss -> {
            try {
                ObjectMetadata objectMetadata = this.createObjectMetadataFromBlob(blob);
                PutObjectRequest request = new PutObjectRequest(container, blob.getMetadata().getProviderId(), blob.getPayload().openStream(), objectMetadata);
                PutObjectResult result = oss.putObject(request);
                return result.getETag();
            }
            catch (IOException e) {
                throw new SLException((Throwable)e);
            }
        });
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    public Blob getBlob(String container, String name, GetOptions options) {
        return this.doOssOperation(oss -> {
            GetObjectRequest req = this.toGetObjectRequest(container, name, options);
            OSSObject object = oss.getObject(req);
            return this.convertToBlob(object);
        }, false);
    }

    public void removeBlob(String container, String name) {
        this.doOssOperation(oss -> {
            oss.deleteObject(container, name);
            return null;
        });
    }

    private <R> R doOssOperation(Function<OSS, R> function) {
        return this.doOssOperation(function, true);
    }

    private <R> R doOssOperation(Function<OSS, R> function, boolean shutdownClient) {
        OSS ossClient = this.aliOSSApi.getOSSClient();
        R result = function.apply(ossClient);
        if (shutdownClient) {
            ossClient.shutdown();
        }
        return result;
    }

    private GetObjectRequest toGetObjectRequest(String container, String name, GetOptions options) {
        GetObjectRequest request = new GetObjectRequest(container, name);
        if (options.getIfModifiedSince() != null) {
            request.setModifiedSinceConstraint(options.getIfModifiedSince());
        }
        if (!options.getRanges().isEmpty()) {
            String[] ranges = ((String)options.getRanges().get(0)).split("-");
            long start = Integer.parseInt(ranges[0]);
            long end = Integer.parseInt(ranges[1]);
            request.setRange(start, end);
        }
        return request;
    }

    private List<StorageMetadata> toStorageMetadataList(OSS oss, String container, ObjectListing objectListing) {
        return objectListing.getObjectSummaries().stream().map(ossObjectSummary -> this.toStorageMetadata(oss, container, (OSSObjectSummary)ossObjectSummary)).collect(Collectors.toList());
    }

    private StorageMetadata toStorageMetadata(OSS oss, String container, OSSObjectSummary ossObjectSummary) {
        ObjectMetadata metadata = oss.getObjectMetadata(container, ossObjectSummary.getKey());
        URI url = this.getPresignedUriForObject(oss, ossObjectSummary);
        return new StorageMetadataImpl(StorageType.BLOB, ossObjectSummary.getKey(), ossObjectSummary.getKey(), (Location)this.defaultLocation.get(), url, ossObjectSummary.getETag(), ossObjectSummary.getLastModified(), ossObjectSummary.getLastModified(), metadata.getUserMetadata(), Long.valueOf(ossObjectSummary.getSize()), Tier.STANDARD);
    }

    private URI getPresignedUriForObject(OSS oss, OSSObjectSummary ossObjectSummary) {
        Calendar time = Calendar.getInstance();
        time.set(10, time.get(10) + 1);
        try {
            return oss.generatePresignedUrl(ossObjectSummary.getBucketName(), ossObjectSummary.getKey(), time.getTime()).toURI();
        }
        catch (URISyntaxException e) {
            throw new SLException((Throwable)e);
        }
    }

    private ListObjectsRequest toListObjectRequest(String container, ListContainerOptions options) {
        ListObjectsRequest request = new ListObjectsRequest(container);
        if (options.getMaxResults() != null) {
            request.setMaxKeys(options.getMaxResults());
        }
        if (options.getMarker() != null) {
            request.setMarker(options.getMarker());
        }
        return request;
    }

    private ObjectMetadata createObjectMetadataFromBlob(Blob blob) {
        Map userMetadata;
        Date lastModified;
        ObjectMetadata objectMetadata = new ObjectMetadata();
        MutableContentMetadata blobContentMetadata = blob.getMetadata().getContentMetadata();
        if (blobContentMetadata.getCacheControl() != null) {
            objectMetadata.setCacheControl(blobContentMetadata.getCacheControl());
        }
        if (blobContentMetadata.getContentDisposition() != null) {
            objectMetadata.setContentDisposition(blobContentMetadata.getContentDisposition());
        }
        if (blobContentMetadata.getContentEncoding() != null) {
            objectMetadata.setContentEncoding(blobContentMetadata.getContentEncoding());
        }
        if (blobContentMetadata.getContentLength() != null) {
            objectMetadata.setContentLength(blobContentMetadata.getContentLength().longValue());
        }
        if (blobContentMetadata.getContentType() != null) {
            objectMetadata.setContentType(blobContentMetadata.getContentType());
        }
        if (blobContentMetadata.getExpires() != null) {
            objectMetadata.setExpirationTime(blobContentMetadata.getExpires());
        }
        if ((lastModified = blob.getMetadata().getLastModified()) != null) {
            objectMetadata.setLastModified(lastModified);
        }
        if (blob.getAllHeaders() != null) {
            blob.getAllHeaders().asMap().forEach((arg_0, arg_1) -> ((ObjectMetadata)objectMetadata).setHeader(arg_0, arg_1));
        }
        if ((userMetadata = blob.getMetadata().getUserMetadata()) != null) {
            objectMetadata.setUserMetadata(userMetadata);
        }
        return objectMetadata;
    }

    private Blob convertToBlob(OSSObject object) {
        BlobBuilder.PayloadBlobBuilder builder = this.blobBuilder(object.getKey()).payload(object.getObjectContent());
        Map userMetadata = object.getObjectMetadata().getUserMetadata();
        if (userMetadata != null) {
            builder.userMetadata(userMetadata);
        }
        return builder.build();
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        throw new UnsupportedOperationException();
    }

    public PageSet<? extends StorageMetadata> list() {
        throw new UnsupportedOperationException();
    }

    public boolean createContainerInLocation(Location location, String container) {
        throw new UnsupportedOperationException();
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        throw new UnsupportedOperationException();
    }

    public ContainerAccess getContainerAccess(String container) {
        throw new UnsupportedOperationException();
    }

    public void setContainerAccess(String container, ContainerAccess access) {
        throw new UnsupportedOperationException();
    }

    public BlobMetadata blobMetadata(String container, String name) {
        throw new UnsupportedOperationException();
    }

    public BlobAccess getBlobAccess(String container, String name) {
        throw new UnsupportedOperationException();
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        throw new UnsupportedOperationException();
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blob, PutOptions options) {
        throw new UnsupportedOperationException();
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        throw new UnsupportedOperationException();
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        throw new UnsupportedOperationException();
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        throw new UnsupportedOperationException();
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        throw new UnsupportedOperationException();
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        throw new UnsupportedOperationException();
    }

    public long getMinimumMultipartPartSize() {
        throw new UnsupportedOperationException();
    }

    public long getMaximumMultipartPartSize() {
        throw new UnsupportedOperationException();
    }

    public int getMaximumNumberOfParts() {
        throw new UnsupportedOperationException();
    }
}

