/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.util;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.cloudfoundry.multiapps.controller.persistence.query.SqlQuery;
import org.cloudfoundry.multiapps.controller.persistence.util.JdbcUtil;

public class SqlQueryExecutor {
    private final DataSource dataSource;

    public SqlQueryExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public <R> R executeWithAutoCommit(SqlQuery<R> sqlQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(true);
            R r = sqlQuery.execute(connection);
            return r;
        }
        catch (SQLException e) {
            JdbcUtil.rollback(connection);
            throw e;
        }
        finally {
            JdbcUtil.closeQuietly(connection);
        }
    }

    public <R> R execute(SqlQuery<R> sqlQuery) throws SQLException {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            R result = sqlQuery.execute(connection);
            JdbcUtil.commit(connection);
            R r = result;
            return r;
        }
        catch (SQLException e) {
            JdbcUtil.rollback(connection);
            throw e;
        }
        finally {
            this.setAutocommitSafely(connection);
            JdbcUtil.closeQuietly(connection);
        }
    }

    private void setAutocommitSafely(Connection connection) throws SQLException {
        if (connection != null) {
            connection.setAutoCommit(true);
        }
    }
}

