/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.multiapps.controller.persistence.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import javax.xml.bind.DatatypeConverter;
import org.cloudfoundry.multiapps.controller.persistence.model.FileInfo;
import org.cloudfoundry.multiapps.controller.persistence.model.ImmutableFileInfo;
import org.cloudfoundry.multiapps.controller.persistence.services.FileStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploader {
    public static final String DIGEST_METHOD = "MD5";
    private static final String EXTENSION = "tmp";
    private static final String PREFIX = "fileUpload";
    private static final Logger logger = LoggerFactory.getLogger(FileUploader.class);

    private FileUploader() {
    }

    public static FileInfo uploadFile(InputStream is) throws FileStorageException {
        File tempFile;
        MessageDigest digest;
        BigInteger size = BigInteger.valueOf(0L);
        try {
            digest = MessageDigest.getInstance(DIGEST_METHOD);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FileStorageException(e);
        }
        try {
            tempFile = File.createTempFile(PREFIX, EXTENSION);
        }
        catch (IOException e) {
            throw new FileStorageException(e);
        }
        try (FileOutputStream outputFileStream = new FileOutputStream(tempFile);){
            int read = 0;
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer, 0, 4096)) > -1) {
                ((OutputStream)outputFileStream).write(buffer, 0, read);
                digest.update(buffer, 0, read);
                size = size.add(BigInteger.valueOf(read));
            }
        }
        catch (Exception e) {
            FileUploader.deleteFile(tempFile);
            throw new FileStorageException(e);
        }
        return ImmutableFileInfo.builder().file(tempFile).size(size).digest(FileUploader.getDigestString(digest.digest())).digestAlgorithm(DIGEST_METHOD).build();
    }

    private static String getDigestString(byte[] digest) {
        return DatatypeConverter.printHexBinary((byte[])digest);
    }

    public static void removeFile(FileInfo uploadedFile) {
        File file = uploadedFile.getFile();
        FileUploader.deleteFile(file);
    }

    private static void deleteFile(File file) {
        Path filePath = file.toPath();
        try {
            Files.delete(filePath);
        }
        catch (IOException e) {
            logger.warn(MessageFormat.format("Failed to delete file {0}", filePath), (Throwable)e);
        }
    }
}

